/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity {
    private volatile MetadataService metadataService;

    public static String getBaseName(String name, MetadataService metadataService) {
        String[] result = name.split("\\.");
        StringBuilder baseName = new StringBuilder().append(result[0]);
        boolean extensionFound = false;
        for (int i = 1; i < result.length && !extensionFound; ++i) {
            boolean bl = extensionFound = metadataService.getMetadata(result[i]) != null;
            if (extensionFound) continue;
            baseName.append(".").append(result[i]);
        }
        return baseName.toString();
    }

    public static Collection<String> getExtensions(String name, MetadataService metadataService) {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        String[] tokens = name.split("\\.");
        boolean extensionFound = false;
        for (i = 1; i < tokens.length && !extensionFound; ++i) {
            extensionFound = metadataService.getMetadata(tokens[i]) != null;
        }
        if (extensionFound) {
            --i;
            while (i < tokens.length) {
                result.add(tokens[i]);
                ++i;
            }
        }
        return result;
    }

    public static Collection<String> getExtensions(Variant variant, MetadataService metadataService) {
        TreeSet<String> result = new TreeSet<String>();
        String extension = metadataService.getExtension(variant.getCharacterSet());
        if (extension != null) {
            result.add(extension);
        }
        if ((extension = metadataService.getExtension(variant.getMediaType())) != null) {
            result.add(extension);
        }
        for (Language language : variant.getLanguages()) {
            extension = metadataService.getExtension(language);
            if (extension == null) continue;
            result.add(extension);
        }
        for (Encoding encoding : variant.getEncodings()) {
            extension = metadataService.getExtension(encoding);
            if (extension == null) continue;
            result.add(extension);
        }
        return result;
    }

    public static void updateMetadata(String entryName, Variant variant, boolean applyDefault, MetadataService metadataService) {
        if (variant != null) {
            String[] tokens = entryName.split("\\.");
            for (int j = 1; j < tokens.length; ++j) {
                String primaryPart;
                int dashIndex;
                Metadata current = metadataService.getMetadata(tokens[j]);
                if (current != null) {
                    boolean found;
                    if (current instanceof MediaType) {
                        variant.setMediaType((MediaType)current);
                    } else if (current instanceof CharacterSet) {
                        variant.setCharacterSet((CharacterSet)current);
                    } else if (current instanceof Encoding) {
                        found = false;
                        for (int i = 0; !found && i < variant.getEncodings().size(); ++i) {
                            found = current.includes(variant.getEncodings().get(i));
                        }
                        if (!found) {
                            variant.getEncodings().add((Encoding)current);
                        }
                    } else if (current instanceof Language) {
                        found = false;
                        for (int i = 0; !found && i < variant.getLanguages().size(); ++i) {
                            found = current.includes(variant.getLanguages().get(i));
                        }
                        if (!found) {
                            variant.getLanguages().add((Language)current);
                        }
                    }
                }
                if ((dashIndex = tokens[j].indexOf(45)) == -1 || !((current = metadataService.getMetadata(primaryPart = tokens[j].substring(0, dashIndex))) instanceof Language)) continue;
                variant.getLanguages().add((Language)current);
            }
            if (applyDefault) {
                CharacterSet defaultCharacterSet;
                Encoding defaultEncoding;
                MediaType defaultMediaType;
                Language defaultLanguage;
                if (variant.getLanguages().isEmpty() && (defaultLanguage = metadataService.getDefaultLanguage()) != null && !defaultLanguage.equals(Language.ALL)) {
                    variant.getLanguages().add(defaultLanguage);
                }
                if (variant.getMediaType() == null && (defaultMediaType = metadataService.getDefaultMediaType()) != null && !defaultMediaType.equals(MediaType.ALL)) {
                    variant.setMediaType(defaultMediaType);
                }
                if (variant.getEncodings().isEmpty() && (defaultEncoding = metadataService.getDefaultEncoding()) != null && !defaultEncoding.equals(Encoding.ALL) && !defaultEncoding.equals(Encoding.IDENTITY)) {
                    variant.getEncodings().add(defaultEncoding);
                }
                if (variant.getCharacterSet() == null && (defaultCharacterSet = metadataService.getDefaultCharacterSet()) != null && !defaultCharacterSet.equals(CharacterSet.ALL)) {
                    variant.setCharacterSet(defaultCharacterSet);
                }
            }
        }
    }

    public Entity(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public abstract boolean exists();

    public String getBaseName() {
        return Entity.getBaseName(this.getName(), this.getMetadataService());
    }

    public abstract List<Entity> getChildren();

    public Collection<String> getExtensions() {
        return Entity.getExtensions(this.getName(), this.getMetadataService());
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    public abstract String getName();

    public abstract Entity getParent();

    public abstract Representation getRepresentation(MediaType var1, int var2);

    public Variant getVariant() {
        Variant result = new Variant();
        Entity.updateMetadata(this.getName(), result, true, this.getMetadataService());
        return result;
    }

    public abstract boolean isDirectory();

    public abstract boolean isNormal();
}

