/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.signals;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.AbstractStatefulEvaluator;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.VectorOutputEvaluator;
import gov.sandia.cognition.math.matrix.VectorizableVectorFunction;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReferences(references={@PublicationReference(author={"Norman S. Nise"}, title="Control Systems Engineering, Second Edition", type=PublicationType.Book, year=1995, pages={648, 702}, notes={"Chapter 12"}), @PublicationReference(author={"Wikipedia"}, title="Linear dynamical system", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Linear_dynamical_system", notes={"This Wikipedia page is simply horrible..."})})
public class LinearDynamicalSystem
extends AbstractStatefulEvaluator<Vector, Vector, Vector>
implements VectorizableVectorFunction,
VectorInputEvaluator<Vector, Vector>,
VectorOutputEvaluator<Vector, Vector> {
    private Matrix A;
    private Matrix B;
    private Matrix C;

    public LinearDynamicalSystem() {
        this(1, 1);
    }

    public LinearDynamicalSystem(int inputDimensionality, int stateDimensionality) {
        this(inputDimensionality, stateDimensionality, stateDimensionality);
    }

    public LinearDynamicalSystem(int inputDimensionality, int stateDimensionality, int outputDimensionality) {
        this(MatrixFactory.getDefault().createIdentity(stateDimensionality, stateDimensionality), MatrixFactory.getDefault().createMatrix(stateDimensionality, inputDimensionality), MatrixFactory.getDefault().createIdentity(outputDimensionality, stateDimensionality));
    }

    public LinearDynamicalSystem(Matrix A, Matrix B) {
        this(A, B, MatrixFactory.getDefault().createIdentity(A.getNumRows(), A.getNumRows()));
    }

    public LinearDynamicalSystem(Matrix A, Matrix B, Matrix C) {
        if (!A.isSquare()) {
            throw new IllegalArgumentException("A must be square!");
        }
        if (A.getNumRows() != B.getNumRows()) {
            throw new IllegalArgumentException("A and B must have same number of rows!");
        }
        if (A.getNumRows() != C.getNumColumns()) {
            throw new IllegalArgumentException("Number of A rows must equal number of C columns!");
        }
        this.setA(A);
        this.setB(B);
        this.setC(C);
    }

    @Override
    public LinearDynamicalSystem clone() {
        LinearDynamicalSystem clone = (LinearDynamicalSystem)super.clone();
        clone.setA(ObjectUtil.cloneSafe(this.getA()));
        clone.setB(ObjectUtil.cloneSafe(this.getB()));
        clone.setC(ObjectUtil.cloneSafe(this.getC()));
        return clone;
    }

    @Override
    public Vector createDefaultState() {
        return VectorFactory.getDefault().createVector(this.getStateDimensionality());
    }

    @Override
    public Vector evaluate(Vector input) {
        Vector xnm1 = (Vector)this.getState();
        Vector xn = this.A.times(xnm1);
        xn.plusEquals(this.B.times(input));
        this.setState(xn);
        return this.C.times(xn);
    }

    @Override
    public Vector convertToVector() {
        return this.A.convertToVector().stack(this.B.convertToVector());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        int Bdim;
        int Adim = this.A.getNumRows() * this.A.getNumColumns();
        if (Adim + (Bdim = this.B.getNumRows() * this.B.getNumColumns()) != parameters.getDimensionality()) {
            throw new IllegalArgumentException("Number of parameters doesn't equal A and B elements!");
        }
        Vector av = parameters.subVector(0, Adim - 1);
        Vector bv = parameters.subVector(Adim, parameters.getDimensionality() - 1);
        this.A.convertFromVector(av);
        this.B.convertFromVector(bv);
    }

    @Override
    public int getInputDimensionality() {
        return this.B.getNumColumns();
    }

    @Override
    public int getOutputDimensionality() {
        return this.C.getNumRows();
    }

    public int getStateDimensionality() {
        return this.A.getNumRows();
    }

    public String toString() {
        StringBuffer retval = new StringBuffer(1000);
        retval.append("x = " + this.getState() + "\n");
        retval.append("A =\n" + this.getA() + "\n");
        retval.append("B = \n" + this.getB() + "\n");
        retval.append("C = \n" + this.getC() + "\n");
        return retval.toString();
    }

    public Matrix getA() {
        return this.A;
    }

    public void setA(Matrix A) {
        this.A = A;
    }

    public Matrix getB() {
        return this.B;
    }

    public void setB(Matrix B) {
        this.B = B;
    }

    public Matrix getC() {
        return this.C;
    }

    public void setC(Matrix C) {
        this.C = C;
    }
}

