/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vector2D;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;

@CodeReview(reviewer={"Justin Basilico"}, date="2006-07-26", changesNeeded=false, comments={"Looks good."})
public class Vector2
extends DenseVector
implements Vector2D {
    public Vector2() {
        this(0.0, 0.0);
    }

    public Vector2(double x, double y) {
        super(2);
        this.setX(x);
        this.setY(y);
    }

    public Vector2(Vector other) {
        this(other.getElement(0), other.getElement(1));
        this.assertSameDimensionality(other);
    }

    public Vector2(Vector2D other) {
        this(other.getX(), other.getY());
    }

    @Override
    public Vector2 clone() {
        return (Vector2)super.clone();
    }

    @Override
    public int getDimensionality() {
        return 2;
    }

    @Override
    public double getX() {
        return this.getElement(0);
    }

    @Override
    public void setX(double x) {
        this.setElement(0, x);
    }

    @Override
    public double getY() {
        return this.getElement(1);
    }

    @Override
    public void setY(double y) {
        this.setElement(1, y);
    }

    @Override
    public void setXY(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    @Override
    public String toString() {
        return "<" + this.getX() + ", " + this.getY() + ">";
    }

    @Override
    public Double getFirst() {
        return this.getX();
    }

    @Override
    public Double getSecond() {
        return this.getY();
    }
}

