/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.decomposition;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.decomposition.SingularValueDecomposition;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-16", changesNeeded=false, comments={"Made very minor changes.", "Otherwise, looks fine."})
public abstract class AbstractSingularValueDecomposition
implements SingularValueDecomposition {
    private Matrix U;
    private Matrix S;
    private Matrix Vtranspose;

    public AbstractSingularValueDecomposition() {
        this(null, null, null);
    }

    public AbstractSingularValueDecomposition(Matrix U, Matrix S, Matrix Vtranspose) {
        this.setU(U);
        this.setS(S);
        this.setVtranspose(Vtranspose);
    }

    @Override
    public Matrix getU() {
        return this.U;
    }

    protected void setU(Matrix U) {
        this.U = U;
    }

    @Override
    public Matrix getS() {
        return this.S;
    }

    protected void setS(Matrix S) {
        this.S = S;
    }

    @Override
    public Matrix getVtranspose() {
        return this.Vtranspose;
    }

    protected void setVtranspose(Matrix Vtranspose) {
        this.Vtranspose = Vtranspose;
    }

    @Override
    public double norm2() {
        double maxSV = this.getS().getElement(0, 0);
        return maxSV;
    }

    @Override
    public double conditionNumber() {
        int N = this.getS().getNumRows();
        double maxSV = this.getS().getElement(0, 0);
        double minSV = this.getS().getElement(N - 1, N - 1);
        double conditionNumber = minSV > 0.0 ? maxSV / minSV : Double.POSITIVE_INFINITY;
        return conditionNumber;
    }

    @Override
    public int rank() {
        return this.effectiveRank(0.0);
    }

    @Override
    public int effectiveRank(double effectiveZero) {
        int n;
        int N = Math.min(this.getS().getNumRows(), this.getS().getNumColumns());
        for (n = 0; n < N && !(this.getS().getElement(n, n) <= effectiveZero); ++n) {
        }
        return n;
    }

    @Override
    public Matrix pseudoInverse() {
        return this.pseudoInverse(0.0);
    }

    @Override
    public Matrix pseudoInverse(double effectiveZero) {
        Matrix V = this.getVtranspose().transpose();
        Matrix Utranspose = this.getU().transpose();
        Matrix Spinv = this.getS().transpose();
        int N = Math.min(Spinv.getNumRows(), Spinv.getNumColumns());
        for (int i = 0; i < N; ++i) {
            double singularValue = Spinv.getElement(i, i);
            double svinv = singularValue <= effectiveZero ? 0.0 : 1.0 / singularValue;
            Spinv.setElement(i, i, svinv);
        }
        return V.times(Spinv).times(Utranspose);
    }
}

