/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.math.AbstractRing;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.TwoVectorEntry;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorUnionIterator;
import java.text.NumberFormat;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-27", changesNeeded=false, comments={"Minor changes to formatting and documentation for equals().", "Otherwise, looks good."}), @CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-16", changesNeeded=false, comments={"Added some documentation and other minor changes. Looks ok."})})
public abstract class AbstractVector
extends AbstractRing<Vector>
implements Vector {
    public static final String DEFAULT_DELIMITER = " ";

    @Override
    public double sum() {
        double sum = 0.0;
        for (VectorEntry entry : this) {
            sum += entry.getValue();
        }
        return sum;
    }

    @Override
    public double norm1() {
        double sum = 0.0;
        for (VectorEntry e : this) {
            sum += Math.abs(e.getValue());
        }
        return sum;
    }

    @Override
    public double norm2() {
        return Math.sqrt(this.norm2Squared());
    }

    @Override
    public double normInfinity() {
        double max = 0.0;
        for (VectorEntry e : this) {
            double v = Math.abs(e.getValue());
            if (!(max < v)) continue;
            max = v;
        }
        return max;
    }

    @Override
    public double euclideanDistanceSquared(Vector other) {
        return this.minus(other).norm2Squared();
    }

    @Override
    public double euclideanDistance(Vector other) {
        return Math.sqrt(this.euclideanDistanceSquared(other));
    }

    @Override
    public double angle(Vector other) {
        return Math.acos(this.cosine(other));
    }

    @Override
    public double cosine(Vector other) {
        double dotproduct = this.dotProduct(other);
        if (dotproduct == 0.0) {
            return 0.0;
        }
        double norm1 = this.norm2Squared();
        double norm2 = other.norm2Squared();
        return dotproduct / Math.sqrt(norm1 * norm2);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof Vector) {
            return this.equals((Vector)other, 0.0);
        }
        return false;
    }

    @Override
    public boolean equals(Vector other, double effectiveZero) {
        VectorUnionIterator iterator = new VectorUnionIterator(this, other);
        while (iterator.hasNext()) {
            TwoVectorEntry entry = iterator.next();
            double difference = entry.getFirstValue() - entry.getSecondValue();
            if (!(Math.abs(difference) > effectiveZero)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int dimensionality = this.getDimensionality();
        int result = 7 + dimensionality;
        for (int i = 0; i < dimensionality; ++i) {
            double value = this.getElement(i);
            if (value == 0.0) continue;
            long bits = Double.doubleToLongBits(value);
            result = 47 * result + i ^ (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    @Override
    public boolean checkSameDimensionality(Vector other) {
        return this.getDimensionality() == other.getDimensionality();
    }

    @Override
    public void assertSameDimensionality(Vector other) {
        AbstractVector.assertEqualDimensionality(this, other);
    }

    @Override
    public void assertDimensionalityEquals(int otherDimensionality) {
        if (this.getDimensionality() != otherDimensionality) {
            throw new DimensionalityMismatchException(this.getDimensionality(), otherDimensionality);
        }
    }

    public static void assertEqualDimensionality(Vector first, Vector second) {
        first.assertDimensionalityEquals(second.getDimensionality());
    }

    @Override
    public Vector unitVector() {
        Vector result = (Vector)this.clone();
        result.unitVectorEquals();
        return result;
    }

    @Override
    public void unitVectorEquals() {
        double norm2 = this.norm2();
        if (norm2 != 0.0) {
            this.scaleEquals(1.0 / norm2);
        }
    }

    @Override
    public String toString() {
        int dimensionality = this.getDimensionality();
        StringBuilder builder = new StringBuilder(20 * dimensionality);
        for (int i = 0; i < dimensionality; ++i) {
            if (i > 0) {
                builder.append(DEFAULT_DELIMITER);
            }
            builder.append(this.getElement(i));
        }
        return builder.toString();
    }

    @Override
    public String toString(NumberFormat format) {
        return this.toString(format, DEFAULT_DELIMITER);
    }

    @Override
    public String toString(NumberFormat format, String delimiter) {
        int dimensionality = this.getDimensionality();
        StringBuilder builder = new StringBuilder(20 * dimensionality);
        for (int i = 0; i < dimensionality; ++i) {
            if (i > 0) {
                builder.append(delimiter);
            }
            builder.append(format.format(this.getElement(i)));
        }
        return builder.toString();
    }

    @Override
    public Vector convertToVector() {
        return this;
    }

    @Override
    public void convertFromVector(Vector parameters) {
        this.assertSameDimensionality(parameters);
        for (int i = 0; i < this.getDimensionality(); ++i) {
            this.setElement(i, parameters.getElement(i));
        }
    }

    @Override
    public boolean isZero(double effectiveZero) {
        for (VectorEntry e : this) {
            if (!(Math.abs(e.getValue()) > effectiveZero)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnitVector() {
        return this.isUnitVector(0.0);
    }

    @Override
    public boolean isUnitVector(double tolerance) {
        return Math.abs(this.norm2() - 1.0) <= tolerance;
    }
}

