/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

public class LogMath {
    public static final double LOG_0 = Double.NEGATIVE_INFINITY;
    public static final double LOG_1 = 0.0;
    public static final double LOG_2 = Math.log(2.0);
    public static final double LOG_10 = Math.log(10.0);

    public static double toLog(double x) {
        return Math.log(x);
    }

    public static double fromLog(double logX) {
        return Math.exp(logX);
    }

    public static double add(double logX, double logY) {
        if (logX > logY) {
            return Math.log(1.0 + Math.exp(logY - logX)) + logX;
        }
        if (logY > logX) {
            return Math.log(1.0 + Math.exp(logX - logY)) + logY;
        }
        return logX + LOG_2;
    }

    public static double subtract(double logX, double logY) {
        if (logX > logY) {
            return Math.log(1.0 - Math.exp(logY - logX)) + logX;
        }
        if (logY > logX) {
            return Double.NaN;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static double multiply(double logX, double logY) {
        return logX + logY;
    }

    public static double divide(double logX, double logY) {
        return logX - logY;
    }

    public static double inverse(double logX) {
        return -logX;
    }
}

