/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io.serialization;

import gov.sandia.cognition.io.serialization.AbstractStreamSerializationHandler;
import gov.sandia.cognition.io.serialization.StreamSerializationHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPSerializationHandler<SerializedType>
extends AbstractStreamSerializationHandler<SerializedType> {
    protected StreamSerializationHandler<SerializedType> baseHandler;

    public GZIPSerializationHandler() {
        this(null);
    }

    public GZIPSerializationHandler(StreamSerializationHandler<SerializedType> baseHandler) {
        this.baseHandler = baseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(OutputStream stream, SerializedType object) throws IOException {
        GZIPOutputStream gzip = new GZIPOutputStream(stream);
        try {
            this.baseHandler.writeObject(gzip, object);
        }
        finally {
            gzip.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject(InputStream stream) throws IOException, ClassNotFoundException {
        Object result;
        GZIPInputStream gzip = new GZIPInputStream(stream);
        try {
            result = this.baseHandler.readObject(gzip);
        }
        finally {
            gzip.close();
        }
        return result;
    }

    public StreamSerializationHandler<SerializedType> getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(StreamSerializationHandler<SerializedType> baseHandler) {
        this.baseHandler = baseHandler;
    }
}

