/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.CodeReviews;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2006-07-18", changesNeeded=false, comments={"Minor spacing changes to while statement. Otherwise, looks fine."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=true, comments={"This class should make the comma a parameter (in the splitCommas() method) so that it can be used on all character-delimited parsing schemes."}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2008-02-18", moreChangesNeeded=false, comments={"Added the split() method"})})})
public class CSVUtility {
    public static String[] nextNonEmptyLine(BufferedReader r) throws IOException {
        return CSVUtility.nextNonEmptyLine(r, ',');
    }

    public static String[] nextNonEmptyLine(BufferedReader r, char delimiter) throws IOException {
        String line = null;
        while ((line = r.readLine()) != null) {
            String[] entries;
            if ((line = line.trim()).length() <= 0 || (entries = CSVUtility.split(line, delimiter)) == null || entries.length <= 0) continue;
            return entries;
        }
        return null;
    }

    public static String[] splitCommas(String line) {
        return CSVUtility.split(line, ',');
    }

    public static String[] split(String line, char c) {
        if (line == null) {
            return null;
        }
        int length = line.length();
        if (length <= 0) {
            return new String[0];
        }
        LinkedList<String> list = new LinkedList<String>();
        int start = 0;
        int end = 0;
        while (start < length && (end = line.indexOf(c, start)) >= 0) {
            String entry = line.substring(start, end);
            list.add(entry);
            start = end + 1;
        }
        if (start < length) {
            String last = line.substring(start);
            list.add(last);
        } else {
            list.add("");
        }
        return list.toArray(new String[list.size()]);
    }

    public static LinkedList<String[]> readFile(String fileName) throws IOException {
        return CSVUtility.readFile(fileName, ',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<String[]> readFile(String fileName, char delimiter) throws IOException {
        LinkedList<String[]> result = new LinkedList<String[]>();
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        try {
            String[] line = null;
            while ((line = CSVUtility.nextNonEmptyLine(reader, delimiter)) != null) {
                result.add(line);
            }
        }
        finally {
            reader.close();
        }
        return result;
    }
}

