/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-12-02", changesNeeded=false, comments={"Looks good."})
public class CollectionUtil {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static <DataType> ArrayList<DataType> asArrayList(Iterable<DataType> data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayList) {
            return (ArrayList)data;
        }
        if (data instanceof Collection) {
            return new ArrayList((Collection)data);
        }
        int num = CollectionUtil.size(data);
        ArrayList<DataType> retval = new ArrayList<DataType>(num);
        for (DataType value : data) {
            retval.add(value);
        }
        return retval;
    }

    public static int size(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static int size(Iterable<?> iterable) {
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int counter = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++counter;
        }
        return counter;
    }

    public static <T> T getFirst(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @PublicationReference(author={"William H Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes, Third Edition", type=PublicationType.Book, year=2007, pages={1104}, notes={"Loosely based on the selecti() function"})
    public static <ComparableType> int[] findKthLargest(int k, ArrayList<? extends ComparableType> data, Comparator<? super ComparableType> comparator) {
        int num = data.size();
        int[] indices = new int[num];
        for (int i = 0; i < num; ++i) {
            indices[i] = i;
        }
        int leftIndex = 0;
        int rightIndex = num - 1;
        while (true) {
            if (rightIndex <= leftIndex + 1) {
                if (rightIndex == leftIndex + 1) {
                    CollectionUtil.swapIfAGreaterThanB(leftIndex, rightIndex, indices, data, comparator);
                }
                return indices;
            }
            int mid = (leftIndex + rightIndex) / 2;
            CollectionUtil.swapArrayValues(mid, leftIndex + 1, indices);
            CollectionUtil.swapIfAGreaterThanB(leftIndex, rightIndex, indices, data, comparator);
            CollectionUtil.swapIfAGreaterThanB(leftIndex + 1, rightIndex, indices, data, comparator);
            CollectionUtil.swapIfAGreaterThanB(leftIndex, leftIndex + 1, indices, data, comparator);
            int i = leftIndex + 1;
            int originali = indices[i];
            int j = rightIndex;
            ComparableType valueOriginali = data.get(originali);
            while (true) {
                if (comparator.compare(data.get(indices[++i]), valueOriginali) < 0) {
                    continue;
                }
                while (comparator.compare(data.get(indices[--j]), valueOriginali) > 0) {
                }
                if (j < i) break;
                CollectionUtil.swapArrayValues(i, j, indices);
            }
            indices[leftIndex + 1] = indices[j];
            indices[j] = originali;
            if (j >= k) {
                rightIndex = j - 1;
            }
            if (j > k) continue;
            leftIndex = i;
        }
    }

    private static <ComparableType> boolean swapIfAGreaterThanB(int a, int b, int[] indices, ArrayList<? extends ComparableType> data, Comparator<? super ComparableType> comparator) {
        boolean doSwap;
        boolean bl = doSwap = comparator.compare(data.get(indices[a]), data.get(indices[b])) > 0;
        if (doSwap) {
            CollectionUtil.swapArrayValues(a, b, indices);
        }
        return doSwap;
    }

    private static void swapArrayValues(int i1, int i2, int[] indices) {
        int temp = indices[i1];
        indices[i1] = indices[i2];
        indices[i2] = temp;
    }

    public static <DataType> ArrayList<List<? extends DataType>> createSequentialPartitions(Iterable<? extends DataType> data, int numPartitions) {
        int numData = CollectionUtil.size(data);
        int numEach = numData / numPartitions;
        ArrayList<List<DataType>> retval = new ArrayList<List<DataType>>(numPartitions);
        if (data instanceof List) {
            List list = (List)data;
            int beginIndex = 0;
            int endIndex = beginIndex + numEach;
            for (int i = 0; i < numPartitions; ++i) {
                if (i == numPartitions - 1) {
                    endIndex = numData;
                }
                retval.add(list.subList(beginIndex, endIndex));
                beginIndex = endIndex;
                endIndex += numEach;
            }
        } else {
            int index = 0;
            Iterator<DataType> iterator = data.iterator();
            for (int n = 0; n < numPartitions; ++n) {
                int numThis = n < numPartitions - 1 ? numEach : numData - index;
                ArrayList<DataType> partition = new ArrayList<DataType>(numThis);
                for (int i = 0; i < numThis; ++i) {
                    partition.add(iterator.next());
                    ++index;
                }
                retval.add(partition);
            }
        }
        return retval;
    }

    public static <DataType> DataType getElement(Iterable<DataType> iterable, int index) {
        if (iterable instanceof List) {
            return (DataType)((List)iterable).get(index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        for (DataType v : iterable) {
            if (index == 0) {
                return v;
            }
            --index;
        }
        throw new IndexOutOfBoundsException("index >= iterable size");
    }

    public static <DataType> DataType removeElement(Iterable<DataType> iterable, int index) {
        if (iterable instanceof List) {
            return (DataType)((List)iterable).remove(index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        Iterator<DataType> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            DataType value = iterator.next();
            if (index == 0) {
                iterator.remove();
                return value;
            }
            --index;
        }
        throw new IndexOutOfBoundsException("index >= iterable size");
    }

    public static String toStringDelimited(Iterable<?> list, String delimiter) {
        if (list == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        Iterator<?> iterator = list.iterator();
        if (iterator.hasNext()) {
            result.append(iterator.next());
        }
        while (iterator.hasNext()) {
            result.append(delimiter);
            result.append(iterator.next());
        }
        return result.toString();
    }
}

