/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.util;

import org.ontoware.rdf2go.model.node.Node;

public class SparqlUtil {
    public static String toSparqlLiteral(String raw) {
        return "\"" + SparqlUtil.sparqlEncode(raw) + "\"";
    }

    public static String sparqlEncode(String raw) {
        String result = raw;
        result = result.replace("\\", "\\\\");
        result = result.replace("'", "\\'");
        result = result.replace("\"", "\\\"");
        return result;
    }

    public static String sparqlRegExpEncode(String raw) {
        String result = raw;
        result = result.replace("\\", "\\\\");
        result = result.replace("|", "\\|");
        result = result.replace(".", "\\.");
        result = result.replace("-", "\\-");
        result = result.replace("^", "\\^");
        result = result.replace("?", "\\?");
        result = result.replace("*", "\\*");
        result = result.replace("+", "\\+");
        result = result.replace("{", "\\{");
        result = result.replace("}", "\\}");
        result = result.replace("(", "\\(");
        result = result.replace(")", "\\)");
        result = result.replace("[", "\\[");
        result = result.replace("]", "\\]");
        return result;
    }

    public static String formatQuery(String queryTemplate, Object ... args) {
        Object[] sparqlArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            sparqlArgs[i] = args[i] instanceof Node ? ((Node)args[i]).toSPARQL() : args[i];
        }
        return String.format(queryTemplate, sparqlArgs);
    }
}

