/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFTool {
    private static Logger log = LoggerFactory.getLogger(RDFTool.class);
    private static DateFormat dateTimeFormat = null;
    private static DateFormat dateFormat = null;

    public static Model copyModel(Model m) {
        Model res = RDF2Go.getModelFactory().createModel();
        res.open();
        res.addAll(m.iterator());
        return res;
    }

    public static String dateTime2DateString(Date date) {
        return RDFTool.getDateTimeFormat().format(date);
    }

    public static String dateTime2String(Date date) {
        return RDFTool.getDateTimeFormat().format(date);
    }

    public static String date2String(Date date) {
        return RDFTool.getDateFormat().format(date);
    }

    public static Statement findStatement(Model model, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) {
        ClosableIterator<Statement> i = model.findStatements(subject, predicate, object);
        if (i.hasNext()) {
            Statement s = i.next();
            i.close();
            return s;
        }
        return null;
    }

    public static DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        return dateFormat;
    }

    public static DateFormat getDateTimeFormat() {
        if (dateTimeFormat == null) {
            dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
        return dateTimeFormat;
    }

    public static String getGoodLabel(Node o, Model source) {
        if (o == null) {
            return null;
        }
        if (o instanceof Resource) {
            Node rdfslabel = RDFTool.getSingleValue(source, (Resource)o, RDFS.label);
            if (rdfslabel != null) {
                if (rdfslabel instanceof Literal) {
                    return ((Literal)rdfslabel).getValue();
                }
                return rdfslabel.toString();
            }
            return RDFTool.getShortName(o.toString());
        }
        if (o instanceof Literal) {
            return ((Literal)o).getValue();
        }
        return o.toString();
    }

    public static String getLabel(Node o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Resource) {
            return RDFTool.getShortName(o.toString());
        }
        if (o instanceof Literal) {
            return ((Literal)o).getValue();
        }
        return o.toString();
    }

    public static String getShortName(String uri) {
        String result = uri;
        if (result.indexOf(35) > 0) {
            result = result.substring(result.lastIndexOf(35) + 1);
        } else if (result.indexOf(47) > 0) {
            result = result.substring(result.lastIndexOf(47) + 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node getSingleValue(Model m, Resource res, URI pred) {
        ClosableIterator<Statement> i = m.findStatements(res, pred, Variable.ANY);
        try {
            if (i.hasNext()) {
                Node node = i.next().getObject();
                return node;
            }
            Node node = null;
            return node;
        }
        finally {
            i.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node getSingleValue(ModelSet m, Resource res, URI pred) {
        ClosableIterator<Statement> i = m.findStatements(Variable.ANY, res, pred, Variable.ANY);
        try {
            if (i.hasNext()) {
                Node node = i.next().getObject();
                return node;
            }
            Node node = null;
            return node;
        }
        finally {
            i.close();
        }
    }

    public static String getSingleValueString(Model m, Resource res, URI pred) {
        Node n = RDFTool.getSingleValue(m, res, pred);
        if (n == null) {
            return null;
        }
        if (n instanceof Literal) {
            return ((Literal)n).getValue();
        }
        return n.toString();
    }

    public static String getSingleValueString(ModelSet modelset, Resource res, URI pred) {
        Node n = RDFTool.getSingleValue(modelset, res, pred);
        if (n == null) {
            return null;
        }
        if (n instanceof Literal) {
            return ((Literal)n).getValue();
        }
        return n.toString();
    }

    public static Syntax guessSyntax(String filenname) {
        String suffix = filenname.substring(filenname.lastIndexOf(46) + 1);
        if (suffix != null) {
            if ((suffix = suffix.toLowerCase()).equals("n3")) {
                return Syntax.Turtle;
            }
            if (suffix.equals("nt")) {
                return Syntax.Ntriples;
            }
            if (suffix.equals("trig")) {
                return Syntax.Trig;
            }
            if (suffix.equals("trix")) {
                return Syntax.Trix;
            }
        }
        return Syntax.RdfXml;
    }

    public static String modelToString(Model model) {
        return RDFTool.modelToString(model, Syntax.RdfXml);
    }

    public static String modelToString(ModelSet modelset) {
        return RDFTool.modelToString(modelset, Syntax.RdfXml);
    }

    public static String modelToString(Model model, Syntax syntax) {
        StringWriter buffer = new StringWriter();
        try {
            model.writeTo(buffer, syntax);
        }
        catch (Exception e) {
            throw new ModelRuntimeException(e);
        }
        return buffer.toString();
    }

    public static String modelToString(ModelSet modelset, Syntax syntax) {
        StringWriter buffer = new StringWriter();
        try {
            modelset.writeTo(buffer, syntax);
        }
        catch (Exception e) {
            throw new ModelRuntimeException(e);
        }
        return buffer.toString();
    }

    public static void setSingleValue(Model m, Resource res, URI pred, Node value) {
        m.removeStatements(res, pred, Variable.ANY);
        if (value != null) {
            m.addStatement(res, pred, value);
        }
    }

    public static void setSingleValue(Model m, Resource res, URI pred, String value) {
        m.removeStatements(res, pred, Variable.ANY);
        if (value != null) {
            m.addStatement(res, pred, value);
        }
    }

    public static String sha1sum(String data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = md.digest(data.getBytes());
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            int digByte = digest[i] & 0xFF;
            if (digByte < 16) {
                res.append('0');
            }
            res.append(Integer.toHexString(digByte));
        }
        return res.toString();
    }

    public static Date string2Date(String isodate) throws ParseException {
        return RDFTool.getDateFormat().parse(isodate);
    }

    public static Date string2DateTime(String date) throws ParseException {
        return RDFTool.getDateTimeFormat().parse(date);
    }

    public static Model stringToModel(String rdfxml) {
        return RDFTool.stringToModel(rdfxml, Syntax.RdfXml);
    }

    public static Model stringToModel(String string, Syntax syntax) {
        Model m = RDF2Go.getModelFactory().createModel();
        m.open();
        StringReader s = new StringReader(string);
        try {
            m.readFrom(s, syntax);
            Model model = m;
            return model;
        }
        catch (Exception e) {
            throw new ModelRuntimeException(e);
        }
        finally {
            s.close();
        }
    }
}

