/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.util.Arrays;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.impl.StatementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatement
implements Statement {
    private static Logger log = LoggerFactory.getLogger(StatementImpl.class);

    public void dump(String[] options) {
        boolean sysout = true;
        boolean _log = false;
        if (options != null) {
            sysout = Arrays.asList(options).contains("sysout");
            _log = Arrays.asList(options).contains("log");
        }
        String s = this.toString();
        if (sysout) {
            System.out.println(s);
        }
        if (_log) {
            log.trace(s);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Statement) {
            boolean objects;
            boolean predicates;
            Statement oStmt = (Statement)o;
            boolean subjects = this.getSubject().equals(oStmt.getSubject());
            if (!subjects) {
                log.trace("Subjects differ: " + this.getSubject() + " vs " + oStmt.getSubject());
            }
            if (!(predicates = this.getPredicate().equals(oStmt.getPredicate()))) {
                log.trace("Prediactes differ: " + this.getPredicate() + " vs " + oStmt.getPredicate());
            }
            if (!(objects = this.getObject().equals(oStmt.getObject()))) {
                log.trace("Objects differ: " + this.getObject() + " vs " + oStmt.getObject());
            }
            return subjects && predicates && objects;
        }
        return false;
    }

    public int hashCode() {
        return this.getSubject().hashCode() + this.getPredicate().hashCode() + this.getObject().hashCode();
    }

    public int compareTo(Statement o) {
        log.trace("Comparing " + this + " to " + o);
        if (this.getSubject().equals(o.getSubject())) {
            if (this.getPredicate().equals(o.getPredicate())) {
                return this.getObject().compareTo(o.getObject());
            }
            return this.getPredicate().compareTo(o.getPredicate());
        }
        return this.getSubject().compareTo(o.getSubject());
    }

    public boolean matches(Statement statement) {
        return this.equals(statement);
    }
}

