/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.util.Iterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.ModelWriter;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.DatatypeLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.LanguageTagLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.PlainLiteralImpl;
import org.ontoware.rdf2go.model.node.impl.URIImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelWriter
implements ModelWriter {
    @Override
    public void addAll(Iterator<? extends Statement> other) throws ModelRuntimeException {
        while (other.hasNext()) {
            this.addStatement(other.next());
        }
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal) throws ModelRuntimeException {
        this.addStatement(subject, predicate, new PlainLiteralImpl(literal));
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.addStatement(subject, predicate, new LanguageTagLiteralImpl(literal, languageTag));
    }

    @Override
    public void addStatement(Resource subject, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.addStatement(subject, predicate, new DatatypeLiteralImpl(literal, datatypeURI));
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal) throws ModelRuntimeException {
        this.addStatement((Resource)new URIImpl(subjectURIString), predicate, new PlainLiteralImpl(literal));
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal, String languageTag) throws ModelRuntimeException {
        this.addStatement((Resource)new URIImpl(subjectURIString), predicate, new LanguageTagLiteralImpl(literal, languageTag));
    }

    @Override
    public void addStatement(String subjectURIString, URI predicate, String literal, URI datatypeURI) throws ModelRuntimeException {
        this.addStatement((Resource)new URIImpl(subjectURIString), predicate, new DatatypeLiteralImpl(literal, datatypeURI));
    }

    @Override
    public void addStatement(Statement statement) throws ModelRuntimeException {
        this.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    @Override
    public abstract void addStatement(Resource var1, URI var2, Node var3) throws ModelRuntimeException;
}

