/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.LockException;
import org.ontoware.rdf2go.exception.MalformedQueryException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.exception.SyntaxNotSupportedException;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.QuadPattern;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.QueryRow;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.impl.DiffImpl;
import org.ontoware.rdf2go.model.impl.LazyUnionModelIterator;
import org.ontoware.rdf2go.model.impl.QuadPatternImpl;
import org.ontoware.rdf2go.model.impl.StatementImpl;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelSetImpl
implements ModelSet {
    private boolean locked = false;

    @Override
    public void dump() {
        ClosableIterator<Model> it = this.getModels();
        while (it.hasNext()) {
            Model m = (Model)it.next();
            System.out.println("Dumping model with context: " + m.getContextURI() + " ----------");
            m.dump();
            m.close();
        }
    }

    @Override
    public void removeAll() throws ModelRuntimeException {
        LinkedList models = new LinkedList();
        ClosableIterator<Model> it = this.getModels();
        while (it.hasNext()) {
            models.add(it.next());
        }
        for (Model m : models) {
            assert (m.isOpen());
            m.removeAll();
        }
    }

    @Override
    public Statement createStatement(URI context, Resource subject, URI predicate, Node object) {
        return new StatementImpl(context, subject, predicate, object);
    }

    @Override
    public void readFrom(Reader in, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.readFrom(in);
    }

    @Override
    public void readFrom(InputStream in, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.readFrom(in);
    }

    @Override
    public void writeTo(Writer writer, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.writeTo(writer);
    }

    @Override
    public void writeTo(OutputStream out, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.writeTo(out);
    }

    @Override
    public String serialize(Syntax syntax) throws SyntaxNotSupportedException {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(sw, syntax);
        }
        catch (IOException e) {
            throw new ModelRuntimeException(e);
        }
        return sw.getBuffer().toString();
    }

    @Override
    public boolean containsStatements(UriOrVariable contextURI, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        ClosableIterator<Statement> it = this.findStatements(contextURI, subject, predicate, object);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    @Override
    public void addStatement(URI context, Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.addStatement(this.createStatement(context, subject, predicate, object));
    }

    @Override
    public void addAll(Iterator<? extends Statement> statement) throws ModelRuntimeException {
        while (statement.hasNext()) {
            this.addStatement(statement.next());
        }
    }

    @Override
    public void removeStatement(URI context, Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.removeStatement(this.createStatement(context, subject, predicate, object));
    }

    @Override
    public void removeAll(Iterator<? extends Statement> statement) throws ModelRuntimeException {
        while (statement.hasNext()) {
            this.removeStatement(statement.next());
        }
    }

    @Override
    public void removeStatements(QuadPattern quadPattern) throws ModelRuntimeException {
        this.removeStatements(quadPattern.getContext(), quadPattern.getSubject(), quadPattern.getPredicate(), quadPattern.getObject());
    }

    @Override
    public void removeStatements(UriOrVariable context, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        ClosableIterator<Statement> it = this.findStatements(context, subject, predicate, object);
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        while (it.hasNext()) {
            Statement stmt = it.next();
            stmts.add(stmt);
        }
        it.close();
        for (Statement stmt : stmts) {
            this.removeStatement(stmt);
        }
    }

    @Override
    public BlankNode createBlankNode() {
        Model defaultModel = this.getDefaultModel();
        BlankNode blankNode = defaultModel.createBlankNode();
        defaultModel.close();
        return blankNode;
    }

    @Override
    public BlankNode createBlankNode(String internalID) {
        Model defaultModel = this.getDefaultModel();
        BlankNode blankNode = defaultModel.createBlankNode(internalID);
        defaultModel.close();
        return blankNode;
    }

    @Override
    public URI createURI(String uriString) throws ModelRuntimeException {
        Model defaultModel = this.getDefaultModel();
        URI uri = defaultModel.createURI(uriString);
        defaultModel.close();
        return uri;
    }

    @Override
    public boolean isValidURI(String uriString) {
        Model defaultModel = this.getDefaultModel();
        boolean result = defaultModel.isValidURI(uriString);
        defaultModel.close();
        return result;
    }

    @Override
    public PlainLiteral createPlainLiteral(String literal) {
        Model defaultModel = this.getDefaultModel();
        PlainLiteral result = defaultModel.createPlainLiteral(literal);
        defaultModel.close();
        return result;
    }

    @Override
    public LanguageTagLiteral createLanguageTagLiteral(String literal, String langugeTag) throws ModelRuntimeException {
        Model defaultModel = this.getDefaultModel();
        LanguageTagLiteral result = defaultModel.createLanguageTagLiteral(literal, langugeTag);
        defaultModel.close();
        return result;
    }

    @Override
    public DatatypeLiteral createDatatypeLiteral(String literal, URI datatypeURI) throws ModelRuntimeException {
        Model defaultModel = this.getDefaultModel();
        DatatypeLiteral result = defaultModel.createDatatypeLiteral(literal, datatypeURI);
        defaultModel.close();
        return result;
    }

    @Override
    public Statement createStatement(Resource subject, URI predicate, Node object) {
        Model defaultModel = this.getDefaultModel();
        Statement statement = defaultModel.createStatement(subject, predicate, object);
        defaultModel.close();
        return statement;
    }

    @Override
    public URI newRandomUniqueURI() {
        Model defaultModel = this.getDefaultModel();
        URI result = defaultModel.newRandomUniqueURI();
        defaultModel.close();
        return result;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lock() throws LockException {
        if (this.isLocked()) {
            throw new LockException("Already locked");
        }
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean contains(Statement s) throws ModelRuntimeException {
        QuadPatternImpl quadPattern = new QuadPatternImpl(s.getContext(), s.getSubject(), s.getPredicate(), s.getObject());
        ClosableIterator<Statement> x = this.findStatements(quadPattern);
        boolean result = x.hasNext();
        x.close();
        return result;
    }

    @Override
    public long countStatements(QuadPattern pattern) throws ModelRuntimeException {
        ClosableIterator<Statement> it = this.findStatements(pattern);
        long count = 0L;
        while (it.hasNext()) {
            while (it.hasNext()) {
                ++count;
                it.next();
            }
        }
        return count;
    }

    @Override
    public ClosableIterator<Statement> findStatements(QuadPattern pattern) throws ModelRuntimeException {
        if (pattern.getContext() == Variable.ANY) {
            return new LazyUnionModelIterator(this, pattern);
        }
        assert (pattern.getContext() instanceof URI);
        Model m = this.getModel((URI)pattern.getContext());
        return m.findStatements(pattern);
    }

    @Override
    public ClosableIterator<Statement> findStatements(UriOrVariable contextURI, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        QuadPattern quadPattern = this.createQuadPattern(contextURI, subject, predicate, object);
        return this.findStatements(quadPattern);
    }

    @Override
    public ClosableIterator<Statement> iterator() {
        return new LazyUnionModelIterator(this, new QuadPatternImpl(Variable.ANY, (ResourceOrVariable)Variable.ANY, Variable.ANY, Variable.ANY));
    }

    @Override
    public boolean addModel(Model model) {
        for (Statement s : model) {
            this.addStatement(model.getContextURI(), s.getSubject(), s.getPredicate(), s.getObject());
        }
        return true;
    }

    @Override
    public void addModelSet(ModelSet modelSet) {
        for (Statement s : modelSet) {
            this.addStatement(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(DiffReader diff) throws ModelRuntimeException {
        AbstractModelSetImpl abstractModelSetImpl = this;
        synchronized (abstractModelSetImpl) {
            if (this.isLocked()) {
                throw new ModelRuntimeException("ModelSet is locked, cannot perform an update.");
            }
            for (Statement stmt : diff.getRemoved()) {
                this.removeStatement(stmt);
            }
            for (Statement stmt : diff.getAdded()) {
                this.addStatement(stmt);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public boolean sparqlAsk(String query) throws ModelRuntimeException, MalformedQueryException {
        QueryResultTable table = this.sparqlSelect(query);
        ClosableIterator it = table.iterator();
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    @Override
    public BlankNode addReificationOf(Statement statement) {
        BlankNode bnode = this.createBlankNode();
        return (BlankNode)this.addReificationOf(statement, bnode);
    }

    @Override
    public Resource addReificationOf(Statement statement, Resource resource) {
        DiffImpl diff = new DiffImpl();
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.type, RDF.Statement));
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.subject, statement.getSubject()));
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.predicate, statement.getPredicate()));
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.object, statement.getObject()));
        this.update(diff);
        return resource;
    }

    @Override
    public boolean hasReifications(Statement statement) {
        return this.sparqlAsk("ASK WHERE {  ?res " + RDF.type.toSPARQL() + " " + RDF.Statement.toSPARQL() + " ." + " ?res " + RDF.subject.toSPARQL() + " " + statement.getSubject().toSPARQL() + " ." + " ?res " + RDF.predicate.toSPARQL() + " " + statement.getPredicate().toSPARQL() + " ." + " ?res " + RDF.object.toSPARQL() + " " + statement.getObject().toSPARQL() + " ." + " }");
    }

    @Override
    public Collection<Resource> getAllReificationsOf(Statement statement) {
        QueryResultTable table = this.sparqlSelect("SELECT ?res WHERE { \n ?res " + RDF.type.toSPARQL() + " " + RDF.Statement.toSPARQL() + " ." + " ?res " + RDF.subject.toSPARQL() + " " + statement.getSubject().toSPARQL() + " ." + " ?res " + RDF.predicate.toSPARQL() + " " + statement.getPredicate().toSPARQL() + " ." + " ?res " + RDF.object.toSPARQL() + " " + statement.getObject().toSPARQL() + " ." + " }");
        LinkedList<Resource> result = new LinkedList<Resource>();
        ClosableIterator it = table.iterator();
        while (it.hasNext()) {
            Resource res = ((QueryRow)it.next()).getValue("res").asResource();
            result.add(res);
        }
        it.close();
        return result;
    }

    @Override
    public void deleteReification(Resource reificationResource) {
        DiffImpl diff = new DiffImpl();
        ClosableIterator<Statement> it = this.findStatements(Variable.ANY, reificationResource, RDF.type, RDF.Statement);
        while (it.hasNext()) {
            diff.removeStatement(it.next());
        }
        it.close();
        it = this.findStatements(Variable.ANY, reificationResource, RDF.subject, Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement(it.next());
        }
        it.close();
        it = this.findStatements(Variable.ANY, reificationResource, RDF.predicate, Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement(it.next());
        }
        it.close();
        it = this.findStatements(Variable.ANY, reificationResource, RDF.object, Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement(it.next());
        }
        it.close();
        this.update(diff);
    }

    @Override
    public void addModel(Model model, URI contextURI) {
        ClosableIterator it = model.iterator();
        HashSet<Statement> statements = new HashSet<Statement>();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            statements.add(stmt);
        }
        it.close();
        for (Statement stmt : statements) {
            this.addStatement(contextURI, stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModelIterator
    implements Iterator<Model> {
        private Iterator<URI> iterator;

        public ModelIterator(Iterator<URI> modelURIs) {
            this.iterator = modelURIs;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Model next() {
            return AbstractModelSetImpl.this.getModel(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.next();
        }
    }
}

