/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.image.pixel.Pixel;

public class LineIterators {
    public static Iterator<Pixel> bresenham(Pixel start, Pixel end) {
        return LineIterators.bresenham(start.x, start.y, end.x, end.y);
    }

    public static Iterator<Pixel> bresenham(final int x0, final int y0, final int x1, final int y1) {
        return new Iterator<Pixel>(){
            int x;
            int y;
            final int dx;
            final int dy;
            final int sx;
            final int sy;
            int err;
            Pixel p;
            boolean finished;
            {
                this.x = x0;
                this.y = y0;
                this.dx = Math.abs(x1 - this.x);
                this.dy = Math.abs(y1 - this.y);
                this.sx = this.x < x1 ? 1 : -1;
                this.sy = this.y < y1 ? 1 : -1;
                this.err = this.dx - this.dy;
                this.p = new Pixel();
                this.finished = false;
            }

            @Override
            public boolean hasNext() {
                return !this.finished;
            }

            @Override
            public Pixel next() {
                int e2;
                this.p.x = this.x;
                this.p.y = this.y;
                if (this.x == x1 && this.y == y1) {
                    this.finished = true;
                }
                if ((e2 = 2 * this.err) > -this.dy) {
                    this.err -= this.dy;
                    this.x += this.sx;
                }
                if (e2 < this.dx) {
                    this.err += this.dx;
                    this.y += this.sy;
                }
                return this.p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Pixel> bresenham(final int x0, final int y0, final float fdx, final float fdy) {
        return new Iterator<Pixel>(){
            int x;
            int y;
            final float dx;
            final float dy;
            final int sx;
            final int sy;
            float err;
            Pixel p;
            {
                this.x = x0;
                this.y = y0;
                this.dx = Math.abs(fdx);
                this.dy = Math.abs(fdy);
                this.sx = fdx > 0.0f ? 1 : -1;
                this.sy = fdy > 0.0f ? 1 : -1;
                this.err = this.dx - this.dy;
                this.p = new Pixel();
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Pixel next() {
                this.p.x = this.x;
                this.p.y = this.y;
                float e2 = 2.0f * this.err;
                if (e2 > -this.dy) {
                    this.err -= this.dy;
                    this.x += this.sx;
                }
                if (e2 < this.dx) {
                    this.err += this.dx;
                    this.y += this.sy;
                }
                return this.p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Pixel> supercover(int x1, int y1, int x2, int y2) {
        return LineIterators.supercoverAsList(x1, y1, x2, y2).iterator();
    }

    public static List<Pixel> supercoverAsList(int x1, int y1, int x2, int y2) {
        int xstep;
        int ystep;
        ArrayList<Pixel> pixels = new ArrayList<Pixel>();
        int y = y1;
        int x = x1;
        int dx = x2 - x1;
        int dy = y2 - y1;
        pixels.add(new Pixel(x1, y1));
        if (dy < 0) {
            ystep = -1;
            dy = -dy;
        } else {
            ystep = 1;
        }
        if (dx < 0) {
            xstep = -1;
            dx = -dx;
        } else {
            xstep = 1;
        }
        int ddy = 2 * dy;
        int ddx = 2 * dx;
        if (ddx >= ddy) {
            int error;
            int errorprev = error = dx;
            for (int i = 0; i < dx; ++i) {
                x += xstep;
                if ((error += ddy) > ddx) {
                    y += ystep;
                    if ((error -= ddx) + errorprev < ddx) {
                        pixels.add(new Pixel(x, y - ystep));
                    } else if (error + errorprev > ddx) {
                        pixels.add(new Pixel(x - xstep, y));
                    } else {
                        pixels.add(new Pixel(x, y - ystep));
                        pixels.add(new Pixel(x - xstep, y));
                    }
                }
                pixels.add(new Pixel(x, y));
                errorprev = error;
            }
        } else {
            int error;
            int errorprev = error = dy;
            for (int i = 0; i < dy; ++i) {
                y += ystep;
                if ((error += ddx) > ddy) {
                    x += xstep;
                    if ((error -= ddy) + errorprev < ddy) {
                        pixels.add(new Pixel(x - xstep, y));
                    } else if (error + errorprev > ddy) {
                        pixels.add(new Pixel(x, y - ystep));
                    } else {
                        pixels.add(new Pixel(x - xstep, y));
                        pixels.add(new Pixel(x, y - ystep));
                    }
                }
                pixels.add(new Pixel(x, y));
                errorprev = error;
            }
        }
        return pixels;
    }

    public static List<Pixel> supercoverAsList(Pixel start, Pixel end) {
        return LineIterators.supercoverAsList(start.x, start.y, end.x, end.y);
    }
}

