/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.colour;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.Transforms;

public enum ColourMap {
    Autumn{

        @Override
        public void apply(float val, float[] out) {
            out[0] = 1.0f;
            out[1] = val;
            out[2] = 0.0f;
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Bone{

        @Override
        public void apply(float x, float[] out) {
            out[0] = (float)(x < 0.75f ? 1 : 0) * (0.875f * x) + (float)(x >= 0.75f ? 1 : 0) * (1.375f * x - 0.375f);
            out[1] = (float)(x < 0.375f ? 1 : 0) * (0.875f * x) + (float)(x >= 0.375f && x < 0.75f ? 1 : 0) * (1.2083334f * x - 0.125f) + (float)(x >= 0.75f ? 1 : 0) * (0.875f * x + 0.125f);
            out[2] = (float)(x < 0.375f ? 1 : 0) * (1.2083334f * x) + (float)(x >= 0.375f ? 1 : 0) * (0.875f * x + 0.125f);
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Cool{

        @Override
        public void apply(float x, float[] out) {
            out[0] = x;
            out[1] = 1.0f - x;
            out[2] = 1.0f;
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Copper{

        @Override
        public void apply(float x, float[] out) {
            out[0] = (float)(x < 0.8f ? 1 : 0) * (1.25f * x) + (float)(x >= 0.8f ? 1 : 0);
            out[1] = 0.8f * x;
            out[2] = 0.5f * x;
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Hot{

        @Override
        public void apply(float x, float[] out) {
            out[0] = (float)(x < 0.4f ? 1 : 0) * (2.5f * x) + (float)(x >= 0.4f ? 1 : 0);
            out[1] = (float)(x >= 0.4f && x < 0.8f ? 1 : 0) * (2.5f * x - 1.0f) + (float)(x >= 0.8f ? 1 : 0);
            out[2] = (float)(x >= 0.8f ? 1 : 0) * (5.0f * x - 4.0f);
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    HSV{

        @Override
        public void apply(float x, float[] out) {
            FImage h = new FImage(1, 1);
            FImage s = new FImage(1, 1);
            FImage v = new FImage(1, 1);
            h.pixels[0][0] = x;
            s.pixels[0][0] = 1.0f;
            v.pixels[0][0] = 1.0f;
            MBFImage img = Transforms.HSV_TO_RGB(new MBFImage(ColourSpace.HSV, h, s, v));
            out[0] = ((FImage)img.getBand((int)0)).pixels[0][0];
            out[1] = ((FImage)img.getBand((int)1)).pixels[0][0];
            out[2] = ((FImage)img.getBand((int)2)).pixels[0][0];
        }

        @Override
        public MBFImage apply(FImage img) {
            FImage ones = new FImage(img.width, img.height);
            ones.fill(1.0f);
            MBFImage mbf = new MBFImage(ColourSpace.HSV, img, ones, ones);
            return Transforms.HSV_TO_RGB(mbf);
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Jet{

        @Override
        public void apply(float x, float[] out) {
            out[0] = (float)(x >= 0.375f && x < 0.625f ? 1 : 0) * (4.0f * x - 1.5f) + (float)(x >= 0.625f && x < 0.875f ? 1 : 0) + (float)(x >= 0.875f ? 1 : 0) * (-4.0f * x + 4.5f);
            out[1] = (float)(x >= 0.125f && x < 0.375f ? 1 : 0) * (4.0f * x - 0.5f) + (float)(x >= 0.375f && x < 0.625f ? 1 : 0) + (float)(x >= 0.625f && x < 0.875f ? 1 : 0) * (-4.0f * x + 3.5f);
            out[2] = (float)(x < 0.125f ? 1 : 0) * (4.0f * x + 0.5f) + (float)(x >= 0.125f && x < 0.375f ? 1 : 0) + (float)(x >= 0.375f && x < 0.625f ? 1 : 0) * (-4.0f * x + 2.5f);
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Spring{

        @Override
        public void apply(float x, float[] out) {
            out[0] = 1.0f;
            out[1] = x;
            out[2] = 1.0f - x;
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Summer{

        @Override
        public void apply(float x, float[] out) {
            out[0] = x;
            out[1] = 0.5f + x / 2.0f;
            out[2] = 0.4f;
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Rainbow{

        @Override
        public void apply(float x, float[] out) {
            out[0] = (float)(x < 0.4f ? 1 : 0) + (float)(x >= 0.4f && x < 0.6f ? 1 : 0) * (-5.0f * x + 3.0f) + (float)(x >= 0.8f ? 1 : 0) * (3.3333333f * x - 2.6666667f);
            out[1] = (float)(x < 0.4f ? 1 : 0) * (2.5f * x) + (float)(x >= 0.4f & x < 0.6f ? 1 : 0) + (float)(x >= 0.6f & x < 0.8f ? 1 : 0) * (-5.0f * x + 4.0f);
            out[2] = (float)(x >= 0.6f & x < 0.8f ? 1 : 0) * (5.0f * x - 3.0f) + (float)(x >= 0.8f ? 1 : 0);
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Winter{

        @Override
        public void apply(float x, float[] out) {
            out[0] = 0.0f;
            out[1] = x;
            out[2] = 1.0f - x / 2.0f;
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    Sepia{

        @Override
        public void apply(float x, float[] out) {
            out[0] = (float)(x < 0.375f ? 1 : 0) * (1.5555556f * x) + (float)(x >= 0.375f ? 1 : 0) * (0.6666667f * x + 0.33333334f);
            out[1] = (float)(x < 0.375f ? 1 : 0) * (0.6666667f * x) + (float)(x >= 0.375f && x < 0.75f ? 1 : 0) * (1.5555556f * x - 0.33333334f) + (float)(x >= 0.75f ? 1 : 0) * (0.6666667f * x + 0.33333334f);
            out[1] = (float)(x < 0.75f ? 1 : 0) * (0.6666667f * x) + (float)(x >= 0.75f ? 1 : 0) * (2.0f * x - 1.0f);
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.INTERPOLATED;
        }
    }
    ,
    RGBYMC{
        private final float[][] cols = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * 6.0f), 5);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Prism{
        private final float[][] cols = new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 0.5f, 0.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.6666667f, 0.0f, 1.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * 6.0f), 5);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Accent3{
        private final float[][] cols = new float[][]{{0.47924528f, 0.75849056f, 0.47924528f}, {0.7169811f, 0.65660375f, 0.8f}, {0.954717f, 0.7245283f, 0.50566036f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Accent4{
        private final float[][] cols = new float[][]{{0.47924528f, 0.75849056f, 0.47924528f}, {0.7169811f, 0.65660375f, 0.8f}, {0.954717f, 0.7245283f, 0.50566036f}, {0.9622642f, 0.9622642f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Accent5{
        private final float[][] cols = new float[][]{{0.47924528f, 0.75849056f, 0.47924528f}, {0.7169811f, 0.65660375f, 0.8f}, {0.954717f, 0.7245283f, 0.50566036f}, {0.9622642f, 0.9622642f, 0.5773585f}, {0.21132076f, 0.40754718f, 0.66415095f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Accent6{
        private final float[][] cols = new float[][]{{0.47924528f, 0.75849056f, 0.47924528f}, {0.7169811f, 0.65660375f, 0.8f}, {0.954717f, 0.7245283f, 0.50566036f}, {0.9622642f, 0.9622642f, 0.5773585f}, {0.21132076f, 0.40754718f, 0.66415095f}, {0.9056604f, 0.00754717f, 0.47924528f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Accent7{
        private final float[][] cols = new float[][]{{0.47924528f, 0.75849056f, 0.47924528f}, {0.7169811f, 0.65660375f, 0.8f}, {0.954717f, 0.7245283f, 0.50566036f}, {0.9622642f, 0.9622642f, 0.5773585f}, {0.21132076f, 0.40754718f, 0.66415095f}, {0.9056604f, 0.00754717f, 0.47924528f}, {0.72075474f, 0.34339622f, 0.086792454f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Accent8{
        private final float[][] cols = new float[][]{{0.47924528f, 0.75849056f, 0.47924528f}, {0.7169811f, 0.65660375f, 0.8f}, {0.954717f, 0.7245283f, 0.50566036f}, {0.9622642f, 0.9622642f, 0.5773585f}, {0.21132076f, 0.40754718f, 0.66415095f}, {0.9056604f, 0.00754717f, 0.47924528f}, {0.72075474f, 0.34339622f, 0.086792454f}, {0.38490567f, 0.38490567f, 0.38490567f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Blues3{
        private final float[][] cols = new float[][]{{0.83773583f, 0.8867925f, 0.9320755f}, {0.5962264f, 0.76226413f, 0.8490566f}, {0.18490566f, 0.49056605f, 0.71320754f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Blues4{
        private final float[][] cols = new float[][]{{0.9018868f, 0.91698116f, 0.9622642f}, {0.71320754f, 0.8113208f, 0.87169814f}, {0.40377358f, 0.65660375f, 0.80754715f}, {0.124528304f, 0.4264151f, 0.68301886f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Blues5{
        private final float[][] cols = new float[][]{{0.9018868f, 0.91698116f, 0.9622642f}, {0.71320754f, 0.8113208f, 0.87169814f}, {0.40377358f, 0.65660375f, 0.80754715f}, {0.18490566f, 0.49056605f, 0.71320754f}, {0.03018868f, 0.30566037f, 0.58867925f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Blues6{
        private final float[][] cols = new float[][]{{0.9018868f, 0.91698116f, 0.9622642f}, {0.7471698f, 0.8264151f, 0.9018868f}, {0.5962264f, 0.76226413f, 0.8490566f}, {0.40377358f, 0.65660375f, 0.80754715f}, {0.18490566f, 0.49056605f, 0.71320754f}, {0.03018868f, 0.30566037f, 0.58867925f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Blues7{
        private final float[][] cols = new float[][]{{0.9018868f, 0.91698116f, 0.9622642f}, {0.7471698f, 0.8264151f, 0.9018868f}, {0.5962264f, 0.76226413f, 0.8490566f}, {0.40377358f, 0.65660375f, 0.80754715f}, {0.24905661f, 0.5509434f, 0.7471698f}, {0.124528304f, 0.4264151f, 0.68301886f}, {0.03018868f, 0.26037735f, 0.5584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Blues8{
        private final float[][] cols = new float[][]{{0.9320755f, 0.94716984f, 0.9622642f}, {0.83773583f, 0.8867925f, 0.9320755f}, {0.7471698f, 0.8264151f, 0.9018868f}, {0.5962264f, 0.76226413f, 0.8490566f}, {0.40377358f, 0.65660375f, 0.80754715f}, {0.24905661f, 0.5509434f, 0.7471698f}, {0.124528304f, 0.4264151f, 0.68301886f}, {0.03018868f, 0.26037735f, 0.5584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Blues9{
        private final float[][] cols = new float[][]{{0.9320755f, 0.94716984f, 0.9622642f}, {0.83773583f, 0.8867925f, 0.9320755f}, {0.7471698f, 0.8264151f, 0.9018868f}, {0.5962264f, 0.76226413f, 0.8490566f}, {0.40377358f, 0.65660375f, 0.80754715f}, {0.24905661f, 0.5509434f, 0.7471698f}, {0.124528304f, 0.4264151f, 0.68301886f}, {0.03018868f, 0.30566037f, 0.58867925f}, {0.03018868f, 0.18113208f, 0.40377358f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG3{
        private final float[][] cols = new float[][]{{0.81509435f, 0.6754717f, 0.38113207f}, {0.9245283f, 0.9245283f, 0.9245283f}, {0.33962265f, 0.6792453f, 0.6490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG4{
        private final float[][] cols = new float[][]{{0.6264151f, 0.36603773f, 0.09811321f}, {0.84150946f, 0.73207545f, 0.4716981f}, {0.48301888f, 0.7735849f, 0.7283019f}, {0.003773585f, 0.5018868f, 0.4264151f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG5{
        private final float[][] cols = new float[][]{{0.6264151f, 0.36603773f, 0.09811321f}, {0.84150946f, 0.73207545f, 0.4716981f}, {0.9245283f, 0.9245283f, 0.9245283f}, {0.48301888f, 0.7735849f, 0.7283019f}, {0.003773585f, 0.5018868f, 0.4264151f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG6{
        private final float[][] cols = new float[][]{{0.5283019f, 0.30566037f, 0.03773585f}, {0.81509435f, 0.6754717f, 0.38113207f}, {0.9283019f, 0.8754717f, 0.7358491f}, {0.7509434f, 0.88301885f, 0.86415094f}, {0.33962265f, 0.6792453f, 0.6490566f}, {0.003773585f, 0.38490567f, 0.354717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG7{
        private final float[][] cols = new float[][]{{0.5283019f, 0.30566037f, 0.03773585f}, {0.81509435f, 0.6754717f, 0.38113207f}, {0.9283019f, 0.8754717f, 0.7358491f}, {0.9245283f, 0.9245283f, 0.9245283f}, {0.7509434f, 0.88301885f, 0.86415094f}, {0.33962265f, 0.6792453f, 0.6490566f}, {0.003773585f, 0.38490567f, 0.354717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG8{
        private final float[][] cols = new float[][]{{0.5283019f, 0.30566037f, 0.03773585f}, {0.72075474f, 0.48679245f, 0.16981132f}, {0.84150946f, 0.73207545f, 0.4716981f}, {0.9283019f, 0.8754717f, 0.7358491f}, {0.7509434f, 0.88301885f, 0.86415094f}, {0.48301888f, 0.7735849f, 0.7283019f}, {0.2f, 0.56981134f, 0.53962266f}, {0.003773585f, 0.38490567f, 0.354717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG9{
        private final float[][] cols = new float[][]{{0.5283019f, 0.30566037f, 0.03773585f}, {0.72075474f, 0.48679245f, 0.16981132f}, {0.84150946f, 0.73207545f, 0.4716981f}, {0.9283019f, 0.8754717f, 0.7358491f}, {0.9245283f, 0.9245283f, 0.9245283f}, {0.7509434f, 0.88301885f, 0.86415094f}, {0.48301888f, 0.7735849f, 0.7283019f}, {0.2f, 0.56981134f, 0.53962266f}, {0.003773585f, 0.38490567f, 0.354717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG10{
        private final float[][] cols = new float[][]{{0.31698114f, 0.18113208f, 0.018867925f}, {0.5283019f, 0.30566037f, 0.03773585f}, {0.72075474f, 0.48679245f, 0.16981132f}, {0.84150946f, 0.73207545f, 0.4716981f}, {0.9283019f, 0.8754717f, 0.7358491f}, {0.7509434f, 0.88301885f, 0.86415094f}, {0.48301888f, 0.7735849f, 0.7283019f}, {0.2f, 0.56981134f, 0.53962266f}, {0.003773585f, 0.38490567f, 0.354717f}, {0.0f, 0.2264151f, 0.18113208f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BrBG11{
        private final float[][] cols = new float[][]{{0.31698114f, 0.18113208f, 0.018867925f}, {0.5283019f, 0.30566037f, 0.03773585f}, {0.72075474f, 0.48679245f, 0.16981132f}, {0.84150946f, 0.73207545f, 0.4716981f}, {0.9283019f, 0.8754717f, 0.7358491f}, {0.9245283f, 0.9245283f, 0.9245283f}, {0.7509434f, 0.88301885f, 0.86415094f}, {0.48301888f, 0.7735849f, 0.7283019f}, {0.2f, 0.56981134f, 0.53962266f}, {0.003773585f, 0.38490567f, 0.354717f}, {0.0f, 0.2264151f, 0.18113208f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuGn3{
        private final float[][] cols = new float[][]{{0.86415094f, 0.9245283f, 0.93962264f}, {0.5773585f, 0.81509435f, 0.75849056f}, {0.16603774f, 0.61132073f, 0.35849056f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuGn4{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.6716981f, 0.8528302f, 0.8528302f}, {0.38490567f, 0.73207545f, 0.61886793f}, {0.13207547f, 0.5245283f, 0.26037735f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuGn5{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.6716981f, 0.8528302f, 0.8528302f}, {0.38490567f, 0.73207545f, 0.61886793f}, {0.16603774f, 0.61132073f, 0.35849056f}, {0.0f, 0.41132075f, 0.16603774f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuGn6{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.76981133f, 0.89056605f, 0.8679245f}, {0.5773585f, 0.81509435f, 0.75849056f}, {0.38490567f, 0.73207545f, 0.61886793f}, {0.16603774f, 0.61132073f, 0.35849056f}, {0.0f, 0.41132075f, 0.16603774f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuGn7{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.76981133f, 0.89056605f, 0.8679245f}, {0.5773585f, 0.81509435f, 0.75849056f}, {0.38490567f, 0.73207545f, 0.61886793f}, {0.24528302f, 0.65660375f, 0.44528303f}, {0.13207547f, 0.5245283f, 0.26037735f}, {0.0f, 0.33207548f, 0.13584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuGn8{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.954717f}, {0.86415094f, 0.9245283f, 0.93962264f}, {0.76981133f, 0.89056605f, 0.8679245f}, {0.5773585f, 0.81509435f, 0.75849056f}, {0.38490567f, 0.73207545f, 0.61886793f}, {0.24528302f, 0.65660375f, 0.44528303f}, {0.13207547f, 0.5245283f, 0.26037735f}, {0.0f, 0.33207548f, 0.13584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuGn9{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.954717f}, {0.86415094f, 0.9245283f, 0.93962264f}, {0.76981133f, 0.89056605f, 0.8679245f}, {0.5773585f, 0.81509435f, 0.75849056f}, {0.38490567f, 0.73207545f, 0.61886793f}, {0.24528302f, 0.65660375f, 0.44528303f}, {0.13207547f, 0.5245283f, 0.26037735f}, {0.0f, 0.41132075f, 0.16603774f}, {0.0f, 0.25660378f, 0.101886794f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuPu3{
        private final float[][] cols = new float[][]{{0.84528303f, 0.89056605f, 0.92075473f}, {0.5962264f, 0.709434f, 0.8226415f}, {0.51320755f, 0.3245283f, 0.6301887f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuPu4{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.5283019f, 0.5660377f, 0.7471698f}, {0.51320755f, 0.24528302f, 0.5924528f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuPu5{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.5283019f, 0.5660377f, 0.7471698f}, {0.51320755f, 0.3245283f, 0.6301887f}, {0.48679245f, 0.056603774f, 0.46792454f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuPu6{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.72075474f, 0.79622644f, 0.8679245f}, {0.5962264f, 0.709434f, 0.8226415f}, {0.5283019f, 0.5660377f, 0.7471698f}, {0.51320755f, 0.3245283f, 0.6301887f}, {0.48679245f, 0.056603774f, 0.46792454f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuPu7{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.94716984f}, {0.72075474f, 0.79622644f, 0.8679245f}, {0.5962264f, 0.709434f, 0.8226415f}, {0.5283019f, 0.5660377f, 0.7471698f}, {0.5283019f, 0.40377358f, 0.6679245f}, {0.51320755f, 0.24528302f, 0.5924528f}, {0.41509435f, 0.003773585f, 0.40377358f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuPu8{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.954717f}, {0.84528303f, 0.89056605f, 0.92075473f}, {0.72075474f, 0.79622644f, 0.8679245f}, {0.5962264f, 0.709434f, 0.8226415f}, {0.5283019f, 0.5660377f, 0.7471698f}, {0.5283019f, 0.40377358f, 0.6679245f}, {0.51320755f, 0.24528302f, 0.5924528f}, {0.41509435f, 0.003773585f, 0.40377358f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    BuPu9{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.954717f}, {0.84528303f, 0.89056605f, 0.92075473f}, {0.72075474f, 0.79622644f, 0.8679245f}, {0.5962264f, 0.709434f, 0.8226415f}, {0.5283019f, 0.5660377f, 0.7471698f}, {0.5283019f, 0.40377358f, 0.6679245f}, {0.51320755f, 0.24528302f, 0.5924528f}, {0.48679245f, 0.056603774f, 0.46792454f}, {0.29056603f, 0.0f, 0.28301886f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Dark23{
        private final float[][] cols = new float[][]{{0.101886794f, 0.5962264f, 0.4490566f}, {0.8188679f, 0.35849056f, 0.00754717f}, {0.44150943f, 0.42264152f, 0.6754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Dark24{
        private final float[][] cols = new float[][]{{0.101886794f, 0.5962264f, 0.4490566f}, {0.8188679f, 0.35849056f, 0.00754717f}, {0.44150943f, 0.42264152f, 0.6754717f}, {0.87169814f, 0.15471698f, 0.5207547f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Dark25{
        private final float[][] cols = new float[][]{{0.101886794f, 0.5962264f, 0.4490566f}, {0.8188679f, 0.35849056f, 0.00754717f}, {0.44150943f, 0.42264152f, 0.6754717f}, {0.87169814f, 0.15471698f, 0.5207547f}, {0.38490567f, 0.6264151f, 0.11320755f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Dark26{
        private final float[][] cols = new float[][]{{0.101886794f, 0.5962264f, 0.4490566f}, {0.8188679f, 0.35849056f, 0.00754717f}, {0.44150943f, 0.42264152f, 0.6754717f}, {0.87169814f, 0.15471698f, 0.5207547f}, {0.38490567f, 0.6264151f, 0.11320755f}, {0.8679245f, 0.64528304f, 0.00754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Dark27{
        private final float[][] cols = new float[][]{{0.101886794f, 0.5962264f, 0.4490566f}, {0.8188679f, 0.35849056f, 0.00754717f}, {0.44150943f, 0.42264152f, 0.6754717f}, {0.87169814f, 0.15471698f, 0.5207547f}, {0.38490567f, 0.6264151f, 0.11320755f}, {0.8679245f, 0.64528304f, 0.00754717f}, {0.6264151f, 0.44528303f, 0.109433964f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Dark28{
        private final float[][] cols = new float[][]{{0.101886794f, 0.5962264f, 0.4490566f}, {0.8188679f, 0.35849056f, 0.00754717f}, {0.44150943f, 0.42264152f, 0.6754717f}, {0.87169814f, 0.15471698f, 0.5207547f}, {0.38490567f, 0.6264151f, 0.11320755f}, {0.8679245f, 0.64528304f, 0.00754717f}, {0.6264151f, 0.44528303f, 0.109433964f}, {0.38490567f, 0.38490567f, 0.38490567f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    GnBu3{
        private final float[][] cols = new float[][]{{0.84528303f, 0.91698116f, 0.8264151f}, {0.6339623f, 0.83396226f, 0.68301886f}, {0.25283018f, 0.61132073f, 0.76226413f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    GnBu4{
        private final float[][] cols = new float[][]{{0.9056604f, 0.93962264f, 0.8754717f}, {0.7018868f, 0.8603774f, 0.709434f}, {0.46415094f, 0.76981133f, 0.73962265f}, {0.16226415f, 0.5283019f, 0.7169811f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    GnBu5{
        private final float[][] cols = new float[][]{{0.9056604f, 0.93962264f, 0.8754717f}, {0.7018868f, 0.8603774f, 0.709434f}, {0.46415094f, 0.76981133f, 0.73962265f}, {0.25283018f, 0.61132073f, 0.76226413f}, {0.03018868f, 0.39245284f, 0.6490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    GnBu6{
        private final float[][] cols = new float[][]{{0.9056604f, 0.93962264f, 0.8754717f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.6339623f, 0.83396226f, 0.68301886f}, {0.46415094f, 0.76981133f, 0.73962265f}, {0.25283018f, 0.61132073f, 0.76226413f}, {0.03018868f, 0.39245284f, 0.6490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    GnBu7{
        private final float[][] cols = new float[][]{{0.9056604f, 0.93962264f, 0.8754717f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.6339623f, 0.83396226f, 0.68301886f}, {0.46415094f, 0.76981133f, 0.73962265f}, {0.29433963f, 0.6754717f, 0.79622644f}, {0.16226415f, 0.5283019f, 0.7169811f}, {0.03018868f, 0.33207548f, 0.5962264f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    GnBu8{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.9056604f}, {0.84528303f, 0.91698116f, 0.8264151f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.6339623f, 0.83396226f, 0.68301886f}, {0.46415094f, 0.76981133f, 0.73962265f}, {0.29433963f, 0.6754717f, 0.79622644f}, {0.16226415f, 0.5283019f, 0.7169811f}, {0.03018868f, 0.33207548f, 0.5962264f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    GnBu9{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.9056604f}, {0.84528303f, 0.91698116f, 0.8264151f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.6339623f, 0.83396226f, 0.68301886f}, {0.46415094f, 0.76981133f, 0.73962265f}, {0.29433963f, 0.6754717f, 0.79622644f}, {0.16226415f, 0.5283019f, 0.7169811f}, {0.03018868f, 0.39245284f, 0.6490566f}, {0.03018868f, 0.24150944f, 0.48679245f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greens3{
        private final float[][] cols = new float[][]{{0.86415094f, 0.9245283f, 0.84528303f}, {0.60754716f, 0.8188679f, 0.5849057f}, {0.18490566f, 0.61509436f, 0.31698114f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greens4{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.8792453f}, {0.7018868f, 0.8603774f, 0.6754717f}, {0.43773586f, 0.73962265f, 0.44528303f}, {0.13207547f, 0.5245283f, 0.26037735f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greens5{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.8792453f}, {0.7018868f, 0.8603774f, 0.6754717f}, {0.43773586f, 0.73962265f, 0.44528303f}, {0.18490566f, 0.61509436f, 0.31698114f}, {0.0f, 0.41132075f, 0.16603774f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greens6{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.8792453f}, {0.7509434f, 0.8792453f, 0.7245283f}, {0.60754716f, 0.8188679f, 0.5849057f}, {0.43773586f, 0.73962265f, 0.44528303f}, {0.18490566f, 0.61509436f, 0.31698114f}, {0.0f, 0.41132075f, 0.16603774f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greens7{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.8792453f}, {0.7509434f, 0.8792453f, 0.7245283f}, {0.60754716f, 0.8188679f, 0.5849057f}, {0.43773586f, 0.73962265f, 0.44528303f}, {0.24528302f, 0.64528304f, 0.3509434f}, {0.13207547f, 0.5245283f, 0.26037735f}, {0.0f, 0.33962265f, 0.18867925f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greens8{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.9245283f}, {0.86415094f, 0.9245283f, 0.84528303f}, {0.7509434f, 0.8792453f, 0.7245283f}, {0.60754716f, 0.8188679f, 0.5849057f}, {0.43773586f, 0.73962265f, 0.44528303f}, {0.24528302f, 0.64528304f, 0.3509434f}, {0.13207547f, 0.5245283f, 0.26037735f}, {0.0f, 0.33962265f, 0.18867925f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greens9{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.9245283f}, {0.86415094f, 0.9245283f, 0.84528303f}, {0.7509434f, 0.8792453f, 0.7245283f}, {0.60754716f, 0.8188679f, 0.5849057f}, {0.43773586f, 0.73962265f, 0.44528303f}, {0.24528302f, 0.64528304f, 0.3509434f}, {0.13207547f, 0.5245283f, 0.26037735f}, {0.0f, 0.41132075f, 0.16603774f}, {0.0f, 0.25660378f, 0.101886794f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greys3{
        private final float[][] cols = new float[][]{{0.9056604f, 0.9056604f, 0.9056604f}, {0.71320754f, 0.71320754f, 0.71320754f}, {0.3735849f, 0.3735849f, 0.3735849f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greys4{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9320755f, 0.9320755f}, {0.76981133f, 0.76981133f, 0.76981133f}, {0.5660377f, 0.5660377f, 0.5660377f}, {0.30943397f, 0.30943397f, 0.30943397f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greys5{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9320755f, 0.9320755f}, {0.76981133f, 0.76981133f, 0.76981133f}, {0.5660377f, 0.5660377f, 0.5660377f}, {0.3735849f, 0.3735849f, 0.3735849f}, {0.13962264f, 0.13962264f, 0.13962264f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greys6{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9320755f, 0.9320755f}, {0.8188679f, 0.8188679f, 0.8188679f}, {0.71320754f, 0.71320754f, 0.71320754f}, {0.5660377f, 0.5660377f, 0.5660377f}, {0.3735849f, 0.3735849f, 0.3735849f}, {0.13962264f, 0.13962264f, 0.13962264f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greys7{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9320755f, 0.9320755f}, {0.8188679f, 0.8188679f, 0.8188679f}, {0.71320754f, 0.71320754f, 0.71320754f}, {0.5660377f, 0.5660377f, 0.5660377f}, {0.43396226f, 0.43396226f, 0.43396226f}, {0.30943397f, 0.30943397f, 0.30943397f}, {0.13962264f, 0.13962264f, 0.13962264f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greys8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.9622642f}, {0.9056604f, 0.9056604f, 0.9056604f}, {0.8188679f, 0.8188679f, 0.8188679f}, {0.71320754f, 0.71320754f, 0.71320754f}, {0.5660377f, 0.5660377f, 0.5660377f}, {0.43396226f, 0.43396226f, 0.43396226f}, {0.30943397f, 0.30943397f, 0.30943397f}, {0.13962264f, 0.13962264f, 0.13962264f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Greys9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.9622642f}, {0.9056604f, 0.9056604f, 0.9056604f}, {0.8188679f, 0.8188679f, 0.8188679f}, {0.71320754f, 0.71320754f, 0.71320754f}, {0.5660377f, 0.5660377f, 0.5660377f}, {0.43396226f, 0.43396226f, 0.43396226f}, {0.30943397f, 0.30943397f, 0.30943397f}, {0.13962264f, 0.13962264f, 0.13962264f}, {0.0f, 0.0f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Oranges3{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8679245f, 0.7773585f}, {0.954717f, 0.65660375f, 0.40377358f}, {0.8679245f, 0.3207547f, 0.049056605f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Oranges4{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8943396f, 0.83773583f}, {0.954717f, 0.7169811f, 0.5018868f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.8188679f, 0.26792452f, 0.003773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Oranges5{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8943396f, 0.83773583f}, {0.954717f, 0.7169811f, 0.5018868f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.8679245f, 0.3207547f, 0.049056605f}, {0.6264151f, 0.20377359f, 0.011320755f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Oranges6{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8943396f, 0.83773583f}, {0.954717f, 0.7849057f, 0.61132073f}, {0.954717f, 0.65660375f, 0.40377358f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.8679245f, 0.3207547f, 0.049056605f}, {0.6264151f, 0.20377359f, 0.011320755f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Oranges7{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8943396f, 0.83773583f}, {0.954717f, 0.7849057f, 0.61132073f}, {0.954717f, 0.65660375f, 0.40377358f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.90943396f, 0.3962264f, 0.071698114f}, {0.8188679f, 0.27169812f, 0.003773585f}, {0.5283019f, 0.16981132f, 0.01509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Oranges8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9245283f, 0.8867925f}, {0.95849055f, 0.8679245f, 0.7773585f}, {0.954717f, 0.7849057f, 0.61132073f}, {0.954717f, 0.65660375f, 0.40377358f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.90943396f, 0.3962264f, 0.071698114f}, {0.8188679f, 0.27169812f, 0.003773585f}, {0.5283019f, 0.16981132f, 0.01509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Oranges9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9245283f, 0.8867925f}, {0.95849055f, 0.8679245f, 0.7773585f}, {0.954717f, 0.7849057f, 0.61132073f}, {0.954717f, 0.65660375f, 0.40377358f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.90943396f, 0.3962264f, 0.071698114f}, {0.8188679f, 0.27169812f, 0.003773585f}, {0.6264151f, 0.20377359f, 0.011320755f}, {0.47924528f, 0.14716981f, 0.01509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    OrRd3{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8754717f, 0.754717f}, {0.954717f, 0.7056604f, 0.49811321f}, {0.8566038f, 0.2792453f, 0.19245283f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    OrRd4{
        private final float[][] cols = new float[][]{{0.95849055f, 0.9056604f, 0.8188679f}, {0.954717f, 0.76981133f, 0.5207547f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.8113208f, 0.18113208f, 0.116981134f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    OrRd5{
        private final float[][] cols = new float[][]{{0.95849055f, 0.9056604f, 0.8188679f}, {0.954717f, 0.76981133f, 0.5207547f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.8566038f, 0.2792453f, 0.19245283f}, {0.6754717f, 0.0f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    OrRd6{
        private final float[][] cols = new float[][]{{0.95849055f, 0.9056604f, 0.8188679f}, {0.954717f, 0.8f, 0.5962264f}, {0.954717f, 0.7056604f, 0.49811321f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.8566038f, 0.2792453f, 0.19245283f}, {0.6754717f, 0.0f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    OrRd7{
        private final float[][] cols = new float[][]{{0.95849055f, 0.9056604f, 0.8188679f}, {0.954717f, 0.8f, 0.5962264f}, {0.954717f, 0.7056604f, 0.49811321f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.9018868f, 0.38113207f, 0.27169812f}, {0.8113208f, 0.18113208f, 0.116981134f}, {0.5773585f, 0.0f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    OrRd8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.89056605f}, {0.95849055f, 0.8754717f, 0.754717f}, {0.954717f, 0.8f, 0.5962264f}, {0.954717f, 0.7056604f, 0.49811321f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.9018868f, 0.38113207f, 0.27169812f}, {0.8113208f, 0.18113208f, 0.116981134f}, {0.5773585f, 0.0f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    OrRd9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.89056605f}, {0.95849055f, 0.8754717f, 0.754717f}, {0.954717f, 0.8f, 0.5962264f}, {0.954717f, 0.7056604f, 0.49811321f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.9018868f, 0.38113207f, 0.27169812f}, {0.8113208f, 0.18113208f, 0.116981134f}, {0.6754717f, 0.0f, 0.0f}, {0.47924528f, 0.0f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired3{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired4{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired5{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired6{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}, {0.8566038f, 0.09811321f, 0.10566038f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired7{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.954717f, 0.72075474f, 0.41886792f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired8{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.954717f, 0.72075474f, 0.41886792f}, {0.9622642f, 0.47924528f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired9{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.954717f, 0.72075474f, 0.41886792f}, {0.9622642f, 0.47924528f, 0.0f}, {0.76226413f, 0.6716981f, 0.80754715f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired10{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.954717f, 0.72075474f, 0.41886792f}, {0.9622642f, 0.47924528f, 0.0f}, {0.76226413f, 0.6716981f, 0.80754715f}, {0.4f, 0.23018868f, 0.58113205f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired11{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.954717f, 0.72075474f, 0.41886792f}, {0.9622642f, 0.47924528f, 0.0f}, {0.76226413f, 0.6716981f, 0.80754715f}, {0.4f, 0.23018868f, 0.58113205f}, {0.9622642f, 0.9622642f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Paired12{
        private final float[][] cols = new float[][]{{0.6264151f, 0.7773585f, 0.8566038f}, {0.116981134f, 0.4528302f, 0.6792453f}, {0.6716981f, 0.84150946f, 0.5207547f}, {0.19245283f, 0.6037736f, 0.16603774f}, {0.94716984f, 0.58113205f, 0.5773585f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.954717f, 0.72075474f, 0.41886792f}, {0.9622642f, 0.47924528f, 0.0f}, {0.76226413f, 0.6716981f, 0.80754715f}, {0.4f, 0.23018868f, 0.58113205f}, {0.9622642f, 0.9622642f, 0.5773585f}, {0.6679245f, 0.33584905f, 0.1509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel13{
        private final float[][] cols = new float[][]{{0.94716984f, 0.6792453f, 0.65660375f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.76981133f, 0.8867925f, 0.7433962f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel14{
        private final float[][] cols = new float[][]{{0.94716984f, 0.6792453f, 0.65660375f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.83773583f, 0.76603776f, 0.8603774f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel15{
        private final float[][] cols = new float[][]{{0.94716984f, 0.6792453f, 0.65660375f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.83773583f, 0.76603776f, 0.8603774f}, {0.95849055f, 0.8188679f, 0.6264151f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel16{
        private final float[][] cols = new float[][]{{0.94716984f, 0.6792453f, 0.65660375f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.83773583f, 0.76603776f, 0.8603774f}, {0.95849055f, 0.8188679f, 0.6264151f}, {0.9622642f, 0.9622642f, 0.76981133f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel17{
        private final float[][] cols = new float[][]{{0.94716984f, 0.6792453f, 0.65660375f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.83773583f, 0.76603776f, 0.8603774f}, {0.95849055f, 0.8188679f, 0.6264151f}, {0.9622642f, 0.9622642f, 0.76981133f}, {0.86415094f, 0.81509435f, 0.71320754f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel18{
        private final float[][] cols = new float[][]{{0.94716984f, 0.6792453f, 0.65660375f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.83773583f, 0.76603776f, 0.8603774f}, {0.95849055f, 0.8188679f, 0.6264151f}, {0.9622642f, 0.9622642f, 0.76981133f}, {0.86415094f, 0.81509435f, 0.71320754f}, {0.954717f, 0.8226415f, 0.89056605f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel19{
        private final float[][] cols = new float[][]{{0.94716984f, 0.6792453f, 0.65660375f}, {0.6754717f, 0.7735849f, 0.8566038f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.83773583f, 0.76603776f, 0.8603774f}, {0.95849055f, 0.8188679f, 0.6264151f}, {0.9622642f, 0.9622642f, 0.76981133f}, {0.86415094f, 0.81509435f, 0.71320754f}, {0.954717f, 0.8226415f, 0.89056605f}, {0.91320753f, 0.91320753f, 0.91320753f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel23{
        private final float[][] cols = new float[][]{{0.6754717f, 0.8528302f, 0.7735849f}, {0.954717f, 0.7735849f, 0.6490566f}, {0.76603776f, 0.8037736f, 0.8754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel24{
        private final float[][] cols = new float[][]{{0.6754717f, 0.8528302f, 0.7735849f}, {0.954717f, 0.7735849f, 0.6490566f}, {0.76603776f, 0.8037736f, 0.8754717f}, {0.92075473f, 0.76226413f, 0.8603774f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel25{
        private final float[][] cols = new float[][]{{0.6754717f, 0.8528302f, 0.7735849f}, {0.954717f, 0.7735849f, 0.6490566f}, {0.76603776f, 0.8037736f, 0.8754717f}, {0.92075473f, 0.76226413f, 0.8603774f}, {0.8679245f, 0.9245283f, 0.75849056f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel26{
        private final float[][] cols = new float[][]{{0.6754717f, 0.8528302f, 0.7735849f}, {0.954717f, 0.7735849f, 0.6490566f}, {0.76603776f, 0.8037736f, 0.8754717f}, {0.92075473f, 0.76226413f, 0.8603774f}, {0.8679245f, 0.9245283f, 0.75849056f}, {0.9622642f, 0.91320753f, 0.65660375f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel27{
        private final float[][] cols = new float[][]{{0.6754717f, 0.8528302f, 0.7735849f}, {0.954717f, 0.7735849f, 0.6490566f}, {0.76603776f, 0.8037736f, 0.8754717f}, {0.92075473f, 0.76226413f, 0.8603774f}, {0.8679245f, 0.9245283f, 0.75849056f}, {0.9622642f, 0.91320753f, 0.65660375f}, {0.90943396f, 0.8528302f, 0.76981133f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Pastel28{
        private final float[][] cols = new float[][]{{0.6754717f, 0.8528302f, 0.7735849f}, {0.954717f, 0.7735849f, 0.6490566f}, {0.76603776f, 0.8037736f, 0.8754717f}, {0.92075473f, 0.76226413f, 0.8603774f}, {0.8679245f, 0.9245283f, 0.75849056f}, {0.9622642f, 0.91320753f, 0.65660375f}, {0.90943396f, 0.8528302f, 0.76981133f}, {0.76981133f, 0.76981133f, 0.76981133f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG3{
        private final float[][] cols = new float[][]{{0.8792453f, 0.61509436f, 0.75849056f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.60754716f, 0.8113208f, 0.4f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG4{
        private final float[][] cols = new float[][]{{0.7849057f, 0.10566038f, 0.5245283f}, {0.90943396f, 0.68679243f, 0.8226415f}, {0.69433963f, 0.8490566f, 0.50566036f}, {0.29056603f, 0.6490566f, 0.14339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG5{
        private final float[][] cols = new float[][]{{0.7849057f, 0.10566038f, 0.5245283f}, {0.90943396f, 0.68679243f, 0.8226415f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.69433963f, 0.8490566f, 0.50566036f}, {0.29056603f, 0.6490566f, 0.14339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG6{
        private final float[][] cols = new float[][]{{0.7433962f, 0.101886794f, 0.4716981f}, {0.8792453f, 0.61509436f, 0.75849056f}, {0.954717f, 0.84528303f, 0.9018868f}, {0.8679245f, 0.9245283f, 0.7849057f}, {0.60754716f, 0.8113208f, 0.4f}, {0.29056603f, 0.5509434f, 0.124528304f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG7{
        private final float[][] cols = new float[][]{{0.7433962f, 0.101886794f, 0.4716981f}, {0.8792453f, 0.61509436f, 0.75849056f}, {0.954717f, 0.84528303f, 0.9018868f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.8679245f, 0.9245283f, 0.7849057f}, {0.60754716f, 0.8113208f, 0.4f}, {0.29056603f, 0.5509434f, 0.124528304f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG8{
        private final float[][] cols = new float[][]{{0.7433962f, 0.101886794f, 0.4716981f}, {0.83773583f, 0.4490566f, 0.65660375f}, {0.90943396f, 0.68679243f, 0.8226415f}, {0.954717f, 0.84528303f, 0.9018868f}, {0.8679245f, 0.9245283f, 0.7849057f}, {0.69433963f, 0.8490566f, 0.50566036f}, {0.47924528f, 0.709434f, 0.24528302f}, {0.29056603f, 0.5509434f, 0.124528304f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG9{
        private final float[][] cols = new float[][]{{0.7433962f, 0.101886794f, 0.4716981f}, {0.83773583f, 0.4490566f, 0.65660375f}, {0.90943396f, 0.68679243f, 0.8226415f}, {0.954717f, 0.84528303f, 0.9018868f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.8679245f, 0.9245283f, 0.7849057f}, {0.69433963f, 0.8490566f, 0.50566036f}, {0.47924528f, 0.709434f, 0.24528302f}, {0.29056603f, 0.5509434f, 0.124528304f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG10{
        private final float[][] cols = new float[][]{{0.53584903f, 0.003773585f, 0.30943397f}, {0.7433962f, 0.101886794f, 0.4716981f}, {0.83773583f, 0.4490566f, 0.65660375f}, {0.90943396f, 0.68679243f, 0.8226415f}, {0.954717f, 0.84528303f, 0.9018868f}, {0.8679245f, 0.9245283f, 0.7849057f}, {0.69433963f, 0.8490566f, 0.50566036f}, {0.47924528f, 0.709434f, 0.24528302f}, {0.29056603f, 0.5509434f, 0.124528304f}, {0.14716981f, 0.3773585f, 0.094339624f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PiYG11{
        private final float[][] cols = new float[][]{{0.53584903f, 0.003773585f, 0.30943397f}, {0.7433962f, 0.101886794f, 0.4716981f}, {0.83773583f, 0.4490566f, 0.65660375f}, {0.90943396f, 0.68679243f, 0.8226415f}, {0.954717f, 0.84528303f, 0.9018868f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.8679245f, 0.9245283f, 0.7849057f}, {0.69433963f, 0.8490566f, 0.50566036f}, {0.47924528f, 0.709434f, 0.24528302f}, {0.29056603f, 0.5509434f, 0.124528304f}, {0.14716981f, 0.3773585f, 0.094339624f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn3{
        private final float[][] cols = new float[][]{{0.6603774f, 0.53207546f, 0.7358491f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.47924528f, 0.72075474f, 0.46415094f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn4{
        private final float[][] cols = new float[][]{{0.46415094f, 0.18867925f, 0.5584906f}, {0.73207545f, 0.6226415f, 0.7811321f}, {0.6264151f, 0.8264151f, 0.6037736f}, {0.0f, 0.51320755f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn5{
        private final float[][] cols = new float[][]{{0.46415094f, 0.18867925f, 0.5584906f}, {0.73207545f, 0.6226415f, 0.7811321f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.6264151f, 0.8264151f, 0.6037736f}, {0.0f, 0.51320755f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn6{
        private final float[][] cols = new float[][]{{0.44528303f, 0.15849057f, 0.49433962f}, {0.6603774f, 0.53207546f, 0.7358491f}, {0.87169814f, 0.8f, 0.8754717f}, {0.8188679f, 0.9056604f, 0.79622644f}, {0.47924528f, 0.72075474f, 0.46415094f}, {0.101886794f, 0.4528302f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn7{
        private final float[][] cols = new float[][]{{0.44528303f, 0.15849057f, 0.49433962f}, {0.6603774f, 0.53207546f, 0.7358491f}, {0.87169814f, 0.8f, 0.8754717f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.8188679f, 0.9056604f, 0.79622644f}, {0.47924528f, 0.72075474f, 0.46415094f}, {0.101886794f, 0.4528302f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn8{
        private final float[][] cols = new float[][]{{0.44528303f, 0.15849057f, 0.49433962f}, {0.5773585f, 0.42264152f, 0.64528304f}, {0.73207545f, 0.6226415f, 0.7811321f}, {0.87169814f, 0.8f, 0.8754717f}, {0.8188679f, 0.9056604f, 0.79622644f}, {0.6264151f, 0.8264151f, 0.6037736f}, {0.33962265f, 0.65660375f, 0.36603773f}, {0.101886794f, 0.4528302f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn9{
        private final float[][] cols = new float[][]{{0.44528303f, 0.15849057f, 0.49433962f}, {0.5773585f, 0.42264152f, 0.64528304f}, {0.73207545f, 0.6226415f, 0.7811321f}, {0.87169814f, 0.8f, 0.8754717f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.8188679f, 0.9056604f, 0.79622644f}, {0.6264151f, 0.8264151f, 0.6037736f}, {0.33962265f, 0.65660375f, 0.36603773f}, {0.101886794f, 0.4528302f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn10{
        private final float[][] cols = new float[][]{{0.24150944f, 0.0f, 0.28301886f}, {0.44528303f, 0.15849057f, 0.49433962f}, {0.5773585f, 0.42264152f, 0.64528304f}, {0.73207545f, 0.6226415f, 0.7811321f}, {0.87169814f, 0.8f, 0.8754717f}, {0.8188679f, 0.9056604f, 0.79622644f}, {0.6264151f, 0.8264151f, 0.6037736f}, {0.33962265f, 0.65660375f, 0.36603773f}, {0.101886794f, 0.4528302f, 0.20754717f}, {0.0f, 0.25660378f, 0.101886794f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PRGn11{
        private final float[][] cols = new float[][]{{0.24150944f, 0.0f, 0.28301886f}, {0.44528303f, 0.15849057f, 0.49433962f}, {0.5773585f, 0.42264152f, 0.64528304f}, {0.73207545f, 0.6226415f, 0.7811321f}, {0.87169814f, 0.8f, 0.8754717f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.8188679f, 0.9056604f, 0.79622644f}, {0.6264151f, 0.8264151f, 0.6037736f}, {0.33962265f, 0.65660375f, 0.36603773f}, {0.101886794f, 0.4528302f, 0.20754717f}, {0.0f, 0.25660378f, 0.101886794f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBu3{
        private final float[][] cols = new float[][]{{0.89056605f, 0.87169814f, 0.91320753f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.16226415f, 0.5283019f, 0.7169811f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBu4{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.71320754f, 0.75849056f, 0.8490566f}, {0.43773586f, 0.63773584f, 0.7811321f}, {0.018867925f, 0.42264152f, 0.66415095f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBu5{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.71320754f, 0.75849056f, 0.8490566f}, {0.43773586f, 0.63773584f, 0.7811321f}, {0.16226415f, 0.5283019f, 0.7169811f}, {0.01509434f, 0.33962265f, 0.53207546f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBu6{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.43773586f, 0.63773584f, 0.7811321f}, {0.16226415f, 0.5283019f, 0.7169811f}, {0.01509434f, 0.33962265f, 0.53207546f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBu7{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.43773586f, 0.63773584f, 0.7811321f}, {0.20377359f, 0.54339623f, 0.7245283f}, {0.018867925f, 0.42264152f, 0.66415095f}, {0.011320755f, 0.29433963f, 0.46415094f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBu8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.94716984f}, {0.89056605f, 0.87169814f, 0.91320753f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.43773586f, 0.63773584f, 0.7811321f}, {0.20377359f, 0.54339623f, 0.7245283f}, {0.018867925f, 0.42264152f, 0.66415095f}, {0.011320755f, 0.29433963f, 0.46415094f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBu9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.94716984f}, {0.89056605f, 0.87169814f, 0.91320753f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.43773586f, 0.63773584f, 0.7811321f}, {0.20377359f, 0.54339623f, 0.7245283f}, {0.018867925f, 0.42264152f, 0.66415095f}, {0.01509434f, 0.33962265f, 0.53207546f}, {0.00754717f, 0.21132076f, 0.33207548f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBuGn3{
        private final float[][] cols = new float[][]{{0.89056605f, 0.8528302f, 0.9056604f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.10566038f, 0.54339623f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBuGn4{
        private final float[][] cols = new float[][]{{0.9283019f, 0.9018868f, 0.9320755f}, {0.71320754f, 0.75849056f, 0.8490566f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.00754717f, 0.48679245f, 0.5207547f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBuGn5{
        private final float[][] cols = new float[][]{{0.9283019f, 0.9018868f, 0.9320755f}, {0.71320754f, 0.75849056f, 0.8490566f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.10566038f, 0.54339623f, 0.5773585f}, {0.003773585f, 0.40754718f, 0.33584905f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBuGn6{
        private final float[][] cols = new float[][]{{0.9283019f, 0.9018868f, 0.9320755f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.10566038f, 0.54339623f, 0.5773585f}, {0.003773585f, 0.40754718f, 0.33584905f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBuGn7{
        private final float[][] cols = new float[][]{{0.9283019f, 0.9018868f, 0.9320755f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.20377359f, 0.54339623f, 0.7245283f}, {0.00754717f, 0.48679245f, 0.5207547f}, {0.003773585f, 0.3773585f, 0.3018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBuGn8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.94716984f}, {0.89056605f, 0.8528302f, 0.9056604f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.20377359f, 0.54339623f, 0.7245283f}, {0.00754717f, 0.48679245f, 0.5207547f}, {0.003773585f, 0.3773585f, 0.3018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuBuGn9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.94716984f}, {0.89056605f, 0.8528302f, 0.9056604f}, {0.7849057f, 0.78867924f, 0.8679245f}, {0.6264151f, 0.71320754f, 0.8264151f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.20377359f, 0.54339623f, 0.7245283f}, {0.00754717f, 0.48679245f, 0.5207547f}, {0.003773585f, 0.40754718f, 0.33584905f}, {0.003773585f, 0.26415095f, 0.20377359f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr3{
        private final float[][] cols = new float[][]{{0.90943396f, 0.61509436f, 0.24150944f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.5773585f, 0.53584903f, 0.7358491f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr4{
        private final float[][] cols = new float[][]{{0.8679245f, 0.36603773f, 0.003773585f}, {0.954717f, 0.69433963f, 0.3735849f}, {0.6716981f, 0.64528304f, 0.7924528f}, {0.354717f, 0.2264151f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr5{
        private final float[][] cols = new float[][]{{0.8679245f, 0.36603773f, 0.003773585f}, {0.954717f, 0.69433963f, 0.3735849f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.6716981f, 0.64528304f, 0.7924528f}, {0.354717f, 0.2264151f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr6{
        private final float[][] cols = new float[][]{{0.6754717f, 0.33207548f, 0.02264151f}, {0.90943396f, 0.61509436f, 0.24150944f}, {0.95849055f, 0.84528303f, 0.68679243f}, {0.81509435f, 0.8226415f, 0.8867925f}, {0.5773585f, 0.53584903f, 0.7358491f}, {0.31698114f, 0.14716981f, 0.51320755f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr7{
        private final float[][] cols = new float[][]{{0.6754717f, 0.33207548f, 0.02264151f}, {0.90943396f, 0.61509436f, 0.24150944f}, {0.95849055f, 0.84528303f, 0.68679243f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.81509435f, 0.8226415f, 0.8867925f}, {0.5773585f, 0.53584903f, 0.7358491f}, {0.31698114f, 0.14716981f, 0.51320755f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr8{
        private final float[][] cols = new float[][]{{0.6754717f, 0.33207548f, 0.02264151f}, {0.84528303f, 0.49056605f, 0.0754717f}, {0.954717f, 0.69433963f, 0.3735849f}, {0.95849055f, 0.84528303f, 0.68679243f}, {0.81509435f, 0.8226415f, 0.8867925f}, {0.6716981f, 0.64528304f, 0.7924528f}, {0.48301888f, 0.43396226f, 0.6490566f}, {0.31698114f, 0.14716981f, 0.51320755f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr9{
        private final float[][] cols = new float[][]{{0.6754717f, 0.33207548f, 0.02264151f}, {0.84528303f, 0.49056605f, 0.0754717f}, {0.954717f, 0.69433963f, 0.3735849f}, {0.95849055f, 0.84528303f, 0.68679243f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.81509435f, 0.8226415f, 0.8867925f}, {0.6716981f, 0.64528304f, 0.7924528f}, {0.48301888f, 0.43396226f, 0.6490566f}, {0.31698114f, 0.14716981f, 0.51320755f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr10{
        private final float[][] cols = new float[][]{{0.47924528f, 0.22264151f, 0.03018868f}, {0.6754717f, 0.33207548f, 0.02264151f}, {0.84528303f, 0.49056605f, 0.0754717f}, {0.954717f, 0.69433963f, 0.3735849f}, {0.95849055f, 0.84528303f, 0.68679243f}, {0.81509435f, 0.8226415f, 0.8867925f}, {0.6716981f, 0.64528304f, 0.7924528f}, {0.48301888f, 0.43396226f, 0.6490566f}, {0.31698114f, 0.14716981f, 0.51320755f}, {0.16981132f, 0.0f, 0.28301886f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuOr11{
        private final float[][] cols = new float[][]{{0.47924528f, 0.22264151f, 0.03018868f}, {0.6754717f, 0.33207548f, 0.02264151f}, {0.84528303f, 0.49056605f, 0.0754717f}, {0.954717f, 0.69433963f, 0.3735849f}, {0.95849055f, 0.84528303f, 0.68679243f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.81509435f, 0.8226415f, 0.8867925f}, {0.6716981f, 0.64528304f, 0.7924528f}, {0.48301888f, 0.43396226f, 0.6490566f}, {0.31698114f, 0.14716981f, 0.51320755f}, {0.16981132f, 0.0f, 0.28301886f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuRd3{
        private final float[][] cols = new float[][]{{0.87169814f, 0.8490566f, 0.9018868f}, {0.75849056f, 0.5584906f, 0.7509434f}, {0.83396226f, 0.10566038f, 0.4490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuRd4{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.8113208f, 0.68301886f, 0.81509435f}, {0.84150946f, 0.38113207f, 0.66415095f}, {0.7773585f, 0.06792453f, 0.3245283f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuRd5{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.8113208f, 0.68301886f, 0.81509435f}, {0.84150946f, 0.38113207f, 0.66415095f}, {0.83396226f, 0.10566038f, 0.4490566f}, {0.5735849f, 0.0f, 0.25283018f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuRd6{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.8f, 0.6981132f, 0.8226415f}, {0.75849056f, 0.5584906f, 0.7509434f}, {0.84150946f, 0.38113207f, 0.66415095f}, {0.83396226f, 0.10566038f, 0.4490566f}, {0.5735849f, 0.0f, 0.25283018f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuRd7{
        private final float[][] cols = new float[][]{{0.90943396f, 0.8981132f, 0.9283019f}, {0.8f, 0.6981132f, 0.8226415f}, {0.75849056f, 0.5584906f, 0.7509434f}, {0.84150946f, 0.38113207f, 0.66415095f}, {0.87169814f, 0.15471698f, 0.5207547f}, {0.7773585f, 0.06792453f, 0.3245283f}, {0.5471698f, 0.0f, 0.23773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuRd8{
        private final float[][] cols = new float[][]{{0.9320755f, 0.92075473f, 0.93962264f}, {0.87169814f, 0.8490566f, 0.9018868f}, {0.8f, 0.6981132f, 0.8226415f}, {0.75849056f, 0.5584906f, 0.7509434f}, {0.84150946f, 0.38113207f, 0.66415095f}, {0.87169814f, 0.15471698f, 0.5207547f}, {0.7773585f, 0.06792453f, 0.3245283f}, {0.5471698f, 0.0f, 0.23773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    PuRd9{
        private final float[][] cols = new float[][]{{0.9320755f, 0.92075473f, 0.93962264f}, {0.87169814f, 0.8490566f, 0.9018868f}, {0.8f, 0.6981132f, 0.8226415f}, {0.75849056f, 0.5584906f, 0.7509434f}, {0.84150946f, 0.38113207f, 0.66415095f}, {0.87169814f, 0.15471698f, 0.5207547f}, {0.7773585f, 0.06792453f, 0.3245283f}, {0.5735849f, 0.0f, 0.25283018f}, {0.38867924f, 0.0f, 0.116981134f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Purples3{
        private final float[][] cols = new float[][]{{0.9018868f, 0.8943396f, 0.9245283f}, {0.709434f, 0.71320754f, 0.8301887f}, {0.44150943f, 0.40377358f, 0.6679245f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Purples4{
        private final float[][] cols = new float[][]{{0.91320753f, 0.9056604f, 0.9320755f}, {0.76603776f, 0.75849056f, 0.8528302f}, {0.5962264f, 0.58113205f, 0.754717f}, {0.4f, 0.30566037f, 0.61509436f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Purples5{
        private final float[][] cols = new float[][]{{0.91320753f, 0.9056604f, 0.9320755f}, {0.76603776f, 0.75849056f, 0.8528302f}, {0.5962264f, 0.58113205f, 0.754717f}, {0.44150943f, 0.40377358f, 0.6679245f}, {0.31698114f, 0.14716981f, 0.53962266f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Purples6{
        private final float[][] cols = new float[][]{{0.91320753f, 0.9056604f, 0.9320755f}, {0.8226415f, 0.8226415f, 0.8867925f}, {0.709434f, 0.71320754f, 0.8301887f}, {0.5962264f, 0.58113205f, 0.754717f}, {0.44150943f, 0.40377358f, 0.6679245f}, {0.31698114f, 0.14716981f, 0.53962266f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Purples7{
        private final float[][] cols = new float[][]{{0.91320753f, 0.9056604f, 0.9320755f}, {0.8226415f, 0.8226415f, 0.8867925f}, {0.709434f, 0.71320754f, 0.8301887f}, {0.5962264f, 0.58113205f, 0.754717f}, {0.48301888f, 0.4716981f, 0.7018868f}, {0.4f, 0.30566037f, 0.61509436f}, {0.2792453f, 0.0754717f, 0.50566036f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Purples8{
        private final float[][] cols = new float[][]{{0.9509434f, 0.94716984f, 0.954717f}, {0.9018868f, 0.8943396f, 0.9245283f}, {0.8226415f, 0.8226415f, 0.8867925f}, {0.709434f, 0.71320754f, 0.8301887f}, {0.5962264f, 0.58113205f, 0.754717f}, {0.48301888f, 0.4716981f, 0.7018868f}, {0.4f, 0.30566037f, 0.61509436f}, {0.2792453f, 0.0754717f, 0.50566036f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Purples9{
        private final float[][] cols = new float[][]{{0.9509434f, 0.94716984f, 0.954717f}, {0.9018868f, 0.8943396f, 0.9245283f}, {0.8226415f, 0.8226415f, 0.8867925f}, {0.709434f, 0.71320754f, 0.8301887f}, {0.5962264f, 0.58113205f, 0.754717f}, {0.48301888f, 0.4716981f, 0.7018868f}, {0.4f, 0.30566037f, 0.61509436f}, {0.31698114f, 0.14716981f, 0.53962266f}, {0.23773585f, 0.0f, 0.4716981f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu3{
        private final float[][] cols = new float[][]{{0.9018868f, 0.5207547f, 0.36981133f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.38867924f, 0.63773584f, 0.7811321f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu4{
        private final float[][] cols = new float[][]{{0.76226413f, 0.0f, 0.12075472f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.5509434f, 0.7433962f, 0.83773583f}, {0.018867925f, 0.4264151f, 0.66415095f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu5{
        private final float[][] cols = new float[][]{{0.76226413f, 0.0f, 0.12075472f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.5509434f, 0.7433962f, 0.83773583f}, {0.018867925f, 0.4264151f, 0.66415095f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu6{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.9018868f, 0.5207547f, 0.36981133f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.78867924f, 0.86415094f, 0.9056604f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.124528304f, 0.38490567f, 0.6490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu7{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.9018868f, 0.5207547f, 0.36981133f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.78867924f, 0.86415094f, 0.9056604f}, {0.38867924f, 0.63773584f, 0.7811321f}, {0.124528304f, 0.38490567f, 0.6490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu8{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.78867924f, 0.86415094f, 0.9056604f}, {0.5509434f, 0.7433962f, 0.83773583f}, {0.25283018f, 0.554717f, 0.7358491f}, {0.124528304f, 0.38490567f, 0.6490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu9{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.78867924f, 0.86415094f, 0.9056604f}, {0.5509434f, 0.7433962f, 0.83773583f}, {0.25283018f, 0.554717f, 0.7358491f}, {0.124528304f, 0.38490567f, 0.6490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu10{
        private final float[][] cols = new float[][]{{0.38867924f, 0.0f, 0.116981134f}, {0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.78867924f, 0.86415094f, 0.9056604f}, {0.5509434f, 0.7433962f, 0.83773583f}, {0.25283018f, 0.554717f, 0.7358491f}, {0.124528304f, 0.38490567f, 0.6490566f}, {0.018867925f, 0.18113208f, 0.36603773f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdBu11{
        private final float[][] cols = new float[][]{{0.38867924f, 0.0f, 0.116981134f}, {0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.9320755f, 0.9320755f, 0.9320755f}, {0.78867924f, 0.86415094f, 0.9056604f}, {0.5509434f, 0.7433962f, 0.83773583f}, {0.25283018f, 0.554717f, 0.7358491f}, {0.124528304f, 0.38490567f, 0.6490566f}, {0.018867925f, 0.18113208f, 0.36603773f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy3{
        private final float[][] cols = new float[][]{{0.9018868f, 0.5207547f, 0.36981133f}, {0.9622642f, 0.9622642f, 0.9622642f}, {0.5773585f, 0.5773585f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy4{
        private final float[][] cols = new float[][]{{0.76226413f, 0.0f, 0.12075472f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.7018868f, 0.7018868f, 0.7018868f}, {0.24150944f, 0.24150944f, 0.24150944f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy5{
        private final float[][] cols = new float[][]{{0.76226413f, 0.0f, 0.12075472f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.9622642f, 0.9622642f, 0.9622642f}, {0.7018868f, 0.7018868f, 0.7018868f}, {0.24150944f, 0.24150944f, 0.24150944f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy6{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.9018868f, 0.5207547f, 0.36981133f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.84528303f, 0.84528303f, 0.84528303f}, {0.5773585f, 0.5773585f, 0.5773585f}, {0.29056603f, 0.29056603f, 0.29056603f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy7{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.9018868f, 0.5207547f, 0.36981133f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.9622642f}, {0.84528303f, 0.84528303f, 0.84528303f}, {0.5773585f, 0.5773585f, 0.5773585f}, {0.29056603f, 0.29056603f, 0.29056603f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy8{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.84528303f, 0.84528303f, 0.84528303f}, {0.7018868f, 0.7018868f, 0.7018868f}, {0.509434f, 0.509434f, 0.509434f}, {0.29056603f, 0.29056603f, 0.29056603f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy9{
        private final float[][] cols = new float[][]{{0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.9622642f}, {0.84528303f, 0.84528303f, 0.84528303f}, {0.7018868f, 0.7018868f, 0.7018868f}, {0.509434f, 0.509434f, 0.509434f}, {0.29056603f, 0.29056603f, 0.29056603f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy10{
        private final float[][] cols = new float[][]{{0.38867924f, 0.0f, 0.116981134f}, {0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.84528303f, 0.84528303f, 0.84528303f}, {0.7018868f, 0.7018868f, 0.7018868f}, {0.509434f, 0.509434f, 0.509434f}, {0.29056603f, 0.29056603f, 0.29056603f}, {0.09811321f, 0.09811321f, 0.09811321f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdGy11{
        private final float[][] cols = new float[][]{{0.38867924f, 0.0f, 0.116981134f}, {0.6716981f, 0.09056604f, 0.16226415f}, {0.80754715f, 0.36226416f, 0.29056603f}, {0.92075473f, 0.6226415f, 0.49056605f}, {0.954717f, 0.8264151f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.9622642f}, {0.84528303f, 0.84528303f, 0.84528303f}, {0.7018868f, 0.7018868f, 0.7018868f}, {0.509434f, 0.509434f, 0.509434f}, {0.29056603f, 0.29056603f, 0.29056603f}, {0.09811321f, 0.09811321f, 0.09811321f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdPu3{
        private final float[][] cols = new float[][]{{0.954717f, 0.84528303f, 0.83396226f}, {0.9433962f, 0.6f, 0.68301886f}, {0.7433962f, 0.101886794f, 0.5207547f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdPu4{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8867925f, 0.8528302f}, {0.94716984f, 0.6792453f, 0.6981132f}, {0.9320755f, 0.39245284f, 0.60754716f}, {0.65660375f, 0.003773585f, 0.4754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdPu5{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8867925f, 0.8528302f}, {0.94716984f, 0.6792453f, 0.6981132f}, {0.9320755f, 0.39245284f, 0.60754716f}, {0.7433962f, 0.101886794f, 0.5207547f}, {0.46037737f, 0.003773585f, 0.4490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdPu6{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8867925f, 0.8528302f}, {0.9509434f, 0.7433962f, 0.7245283f}, {0.9433962f, 0.6f, 0.68301886f}, {0.9320755f, 0.39245284f, 0.60754716f}, {0.7433962f, 0.101886794f, 0.5207547f}, {0.46037737f, 0.003773585f, 0.4490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdPu7{
        private final float[][] cols = new float[][]{{0.95849055f, 0.8867925f, 0.8528302f}, {0.9509434f, 0.7433962f, 0.7245283f}, {0.9433962f, 0.6f, 0.68301886f}, {0.9320755f, 0.39245284f, 0.60754716f}, {0.83396226f, 0.19622642f, 0.56981134f}, {0.65660375f, 0.003773585f, 0.4754717f}, {0.46037737f, 0.003773585f, 0.4490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdPu8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.91698116f}, {0.954717f, 0.84528303f, 0.83396226f}, {0.9509434f, 0.7433962f, 0.7245283f}, {0.9433962f, 0.6f, 0.68301886f}, {0.9320755f, 0.39245284f, 0.60754716f}, {0.83396226f, 0.19622642f, 0.56981134f}, {0.65660375f, 0.003773585f, 0.4754717f}, {0.46037737f, 0.003773585f, 0.4490566f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdPu9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.91698116f}, {0.954717f, 0.84528303f, 0.83396226f}, {0.9509434f, 0.7433962f, 0.7245283f}, {0.9433962f, 0.6f, 0.68301886f}, {0.9320755f, 0.39245284f, 0.60754716f}, {0.83396226f, 0.19622642f, 0.56981134f}, {0.65660375f, 0.003773585f, 0.4754717f}, {0.46037737f, 0.003773585f, 0.4490566f}, {0.2754717f, 0.0f, 0.4f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Reds3{
        private final float[][] cols = new float[][]{{0.95849055f, 0.84528303f, 0.7924528f}, {0.9509434f, 0.5509434f, 0.4301887f}, {0.83773583f, 0.16981132f, 0.14339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Reds4{
        private final float[][] cols = new float[][]{{0.95849055f, 0.86415094f, 0.8188679f}, {0.9509434f, 0.65660375f, 0.5471698f}, {0.94716984f, 0.4f, 0.2792453f}, {0.76603776f, 0.09056604f, 0.109433964f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Reds5{
        private final float[][] cols = new float[][]{{0.95849055f, 0.86415094f, 0.8188679f}, {0.9509434f, 0.65660375f, 0.5471698f}, {0.94716984f, 0.4f, 0.2792453f}, {0.83773583f, 0.16981132f, 0.14339623f}, {0.6226415f, 0.056603774f, 0.079245284f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Reds6{
        private final float[][] cols = new float[][]{{0.95849055f, 0.86415094f, 0.8188679f}, {0.9509434f, 0.7056604f, 0.60754716f}, {0.9509434f, 0.5509434f, 0.4301887f}, {0.94716984f, 0.4f, 0.2792453f}, {0.83773583f, 0.16981132f, 0.14339623f}, {0.6226415f, 0.056603774f, 0.079245284f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Reds7{
        private final float[][] cols = new float[][]{{0.95849055f, 0.86415094f, 0.8188679f}, {0.9509434f, 0.7056604f, 0.60754716f}, {0.9509434f, 0.5509434f, 0.4301887f}, {0.94716984f, 0.4f, 0.2792453f}, {0.9018868f, 0.22264151f, 0.16603774f}, {0.76603776f, 0.09056604f, 0.109433964f}, {0.5773585f, 0.0f, 0.049056605f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Reds8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9245283f, 0.9056604f}, {0.95849055f, 0.84528303f, 0.7924528f}, {0.9509434f, 0.7056604f, 0.60754716f}, {0.9509434f, 0.5509434f, 0.4301887f}, {0.94716984f, 0.4f, 0.2792453f}, {0.9018868f, 0.22264151f, 0.16603774f}, {0.76603776f, 0.09056604f, 0.109433964f}, {0.5773585f, 0.0f, 0.049056605f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Reds9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9245283f, 0.9056604f}, {0.95849055f, 0.84528303f, 0.7924528f}, {0.9509434f, 0.7056604f, 0.60754716f}, {0.9509434f, 0.5509434f, 0.4301887f}, {0.94716984f, 0.4f, 0.2792453f}, {0.9018868f, 0.22264151f, 0.16603774f}, {0.76603776f, 0.09056604f, 0.109433964f}, {0.6226415f, 0.056603774f, 0.079245284f}, {0.38867924f, 0.0f, 0.049056605f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu3{
        private final float[][] cols = new float[][]{{0.9509434f, 0.53207546f, 0.33584905f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.5471698f, 0.72075474f, 0.8264151f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu4{
        private final float[][] cols = new float[][]{{0.8113208f, 0.094339624f, 0.10566038f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.64528304f, 0.8188679f, 0.8792453f}, {0.16603774f, 0.46415094f, 0.68679243f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu5{
        private final float[][] cols = new float[][]{{0.8113208f, 0.094339624f, 0.10566038f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.64528304f, 0.8188679f, 0.8792453f}, {0.16603774f, 0.46415094f, 0.68679243f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu6{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.95849055f, 0.84528303f, 0.54339623f}, {0.84528303f, 0.91698116f, 0.9358491f}, {0.5471698f, 0.72075474f, 0.8264151f}, {0.26037735f, 0.44150943f, 0.6792453f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu7{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.95849055f, 0.84528303f, 0.54339623f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.84528303f, 0.91698116f, 0.9358491f}, {0.5471698f, 0.72075474f, 0.8264151f}, {0.26037735f, 0.44150943f, 0.6792453f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu8{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.54339623f}, {0.84528303f, 0.91698116f, 0.9358491f}, {0.64528304f, 0.8188679f, 0.8792453f}, {0.43773586f, 0.6528302f, 0.78867924f}, {0.26037735f, 0.44150943f, 0.6792453f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu9{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.54339623f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.84528303f, 0.91698116f, 0.9358491f}, {0.64528304f, 0.8188679f, 0.8792453f}, {0.43773586f, 0.6528302f, 0.78867924f}, {0.26037735f, 0.44150943f, 0.6792453f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu10{
        private final float[][] cols = new float[][]{{0.6226415f, 0.0f, 0.14339623f}, {0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.54339623f}, {0.84528303f, 0.91698116f, 0.9358491f}, {0.64528304f, 0.8188679f, 0.8792453f}, {0.43773586f, 0.6528302f, 0.78867924f}, {0.26037735f, 0.44150943f, 0.6792453f}, {0.18490566f, 0.20377359f, 0.56226414f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlBu11{
        private final float[][] cols = new float[][]{{0.6226415f, 0.0f, 0.14339623f}, {0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.54339623f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.84528303f, 0.91698116f, 0.9358491f}, {0.64528304f, 0.8188679f, 0.8792453f}, {0.43773586f, 0.6528302f, 0.78867924f}, {0.26037735f, 0.44150943f, 0.6792453f}, {0.18490566f, 0.20377359f, 0.56226414f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn3{
        private final float[][] cols = new float[][]{{0.9509434f, 0.53207546f, 0.33584905f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.5471698f, 0.7811321f, 0.36226416f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn4{
        private final float[][] cols = new float[][]{{0.8113208f, 0.094339624f, 0.10566038f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.6264151f, 0.8188679f, 0.4f}, {0.09811321f, 0.5660377f, 0.24528302f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn5{
        private final float[][] cols = new float[][]{{0.8113208f, 0.094339624f, 0.10566038f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.6264151f, 0.8188679f, 0.4f}, {0.09811321f, 0.5660377f, 0.24528302f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn6{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.8188679f, 0.9018868f, 0.5245283f}, {0.5471698f, 0.7811321f, 0.36226416f}, {0.09811321f, 0.5735849f, 0.3018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn7{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.8188679f, 0.9018868f, 0.5245283f}, {0.5471698f, 0.7811321f, 0.36226416f}, {0.09811321f, 0.5735849f, 0.3018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn8{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.8188679f, 0.9018868f, 0.5245283f}, {0.6264151f, 0.8188679f, 0.4f}, {0.38490567f, 0.71320754f, 0.3735849f}, {0.09811321f, 0.5735849f, 0.3018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn9{
        private final float[][] cols = new float[][]{{0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.8188679f, 0.9018868f, 0.5245283f}, {0.6264151f, 0.8188679f, 0.4f}, {0.38490567f, 0.71320754f, 0.3735849f}, {0.09811321f, 0.5735849f, 0.3018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn10{
        private final float[][] cols = new float[][]{{0.6226415f, 0.0f, 0.14339623f}, {0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.8188679f, 0.9018868f, 0.5245283f}, {0.6264151f, 0.8188679f, 0.4f}, {0.38490567f, 0.71320754f, 0.3735849f}, {0.09811321f, 0.5735849f, 0.3018868f}, {0.0f, 0.39245284f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    RdYlGn11{
        private final float[][] cols = new float[][]{{0.6226415f, 0.0f, 0.14339623f}, {0.8113208f, 0.18113208f, 0.14716981f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.8188679f, 0.9018868f, 0.5245283f}, {0.6264151f, 0.8188679f, 0.4f}, {0.38490567f, 0.71320754f, 0.3735849f}, {0.09811321f, 0.5735849f, 0.3018868f}, {0.0f, 0.39245284f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set13{
        private final float[][] cols = new float[][]{{0.8603774f, 0.09811321f, 0.10566038f}, {0.20754717f, 0.4754717f, 0.69433963f}, {0.29056603f, 0.6603774f, 0.2792453f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set14{
        private final float[][] cols = new float[][]{{0.8603774f, 0.09811321f, 0.10566038f}, {0.20754717f, 0.4754717f, 0.69433963f}, {0.29056603f, 0.6603774f, 0.2792453f}, {0.5735849f, 0.29433963f, 0.61509436f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set15{
        private final float[][] cols = new float[][]{{0.8603774f, 0.09811321f, 0.10566038f}, {0.20754717f, 0.4754717f, 0.69433963f}, {0.29056603f, 0.6603774f, 0.2792453f}, {0.5735849f, 0.29433963f, 0.61509436f}, {0.9622642f, 0.47924528f, 0.0f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set16{
        private final float[][] cols = new float[][]{{0.8603774f, 0.09811321f, 0.10566038f}, {0.20754717f, 0.4754717f, 0.69433963f}, {0.29056603f, 0.6603774f, 0.2792453f}, {0.5735849f, 0.29433963f, 0.61509436f}, {0.9622642f, 0.47924528f, 0.0f}, {0.9622642f, 0.9622642f, 0.19245283f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set17{
        private final float[][] cols = new float[][]{{0.8603774f, 0.09811321f, 0.10566038f}, {0.20754717f, 0.4754717f, 0.69433963f}, {0.29056603f, 0.6603774f, 0.2792453f}, {0.5735849f, 0.29433963f, 0.61509436f}, {0.9622642f, 0.47924528f, 0.0f}, {0.9622642f, 0.9622642f, 0.19245283f}, {0.6264151f, 0.3245283f, 0.1509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set18{
        private final float[][] cols = new float[][]{{0.8603774f, 0.09811321f, 0.10566038f}, {0.20754717f, 0.4754717f, 0.69433963f}, {0.29056603f, 0.6603774f, 0.2792453f}, {0.5735849f, 0.29433963f, 0.61509436f}, {0.9622642f, 0.47924528f, 0.0f}, {0.9622642f, 0.9622642f, 0.19245283f}, {0.6264151f, 0.3245283f, 0.1509434f}, {0.9320755f, 0.48679245f, 0.72075474f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set19{
        private final float[][] cols = new float[][]{{0.8603774f, 0.09811321f, 0.10566038f}, {0.20754717f, 0.4754717f, 0.69433963f}, {0.29056603f, 0.6603774f, 0.2792453f}, {0.5735849f, 0.29433963f, 0.61509436f}, {0.9622642f, 0.47924528f, 0.0f}, {0.9622642f, 0.9622642f, 0.19245283f}, {0.6264151f, 0.3245283f, 0.1509434f}, {0.9320755f, 0.48679245f, 0.72075474f}, {0.5773585f, 0.5773585f, 0.5773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set23{
        private final float[][] cols = new float[][]{{0.38490567f, 0.73207545f, 0.6226415f}, {0.9509434f, 0.53207546f, 0.36981133f}, {0.53207546f, 0.6037736f, 0.76603776f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set24{
        private final float[][] cols = new float[][]{{0.38490567f, 0.73207545f, 0.6226415f}, {0.9509434f, 0.53207546f, 0.36981133f}, {0.53207546f, 0.6037736f, 0.76603776f}, {0.87169814f, 0.5207547f, 0.7358491f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set25{
        private final float[][] cols = new float[][]{{0.38490567f, 0.73207545f, 0.6226415f}, {0.9509434f, 0.53207546f, 0.36981133f}, {0.53207546f, 0.6037736f, 0.76603776f}, {0.87169814f, 0.5207547f, 0.7358491f}, {0.6264151f, 0.81509435f, 0.31698114f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set26{
        private final float[][] cols = new float[][]{{0.38490567f, 0.73207545f, 0.6226415f}, {0.9509434f, 0.53207546f, 0.36981133f}, {0.53207546f, 0.6037736f, 0.76603776f}, {0.87169814f, 0.5207547f, 0.7358491f}, {0.6264151f, 0.81509435f, 0.31698114f}, {0.9622642f, 0.8188679f, 0.1773585f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set27{
        private final float[][] cols = new float[][]{{0.38490567f, 0.73207545f, 0.6226415f}, {0.9509434f, 0.53207546f, 0.36981133f}, {0.53207546f, 0.6037736f, 0.76603776f}, {0.87169814f, 0.5207547f, 0.7358491f}, {0.6264151f, 0.81509435f, 0.31698114f}, {0.9622642f, 0.8188679f, 0.1773585f}, {0.86415094f, 0.73962265f, 0.5584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set28{
        private final float[][] cols = new float[][]{{0.38490567f, 0.73207545f, 0.6226415f}, {0.9509434f, 0.53207546f, 0.36981133f}, {0.53207546f, 0.6037736f, 0.76603776f}, {0.87169814f, 0.5207547f, 0.7358491f}, {0.6264151f, 0.81509435f, 0.31698114f}, {0.9622642f, 0.8188679f, 0.1773585f}, {0.86415094f, 0.73962265f, 0.5584906f}, {0.6754717f, 0.6754717f, 0.6754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set33{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set34{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set35{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set36{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}, {0.954717f, 0.6792453f, 0.36981133f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set37{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}, {0.954717f, 0.6792453f, 0.36981133f}, {0.6754717f, 0.83773583f, 0.3962264f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set38{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}, {0.954717f, 0.6792453f, 0.36981133f}, {0.6754717f, 0.83773583f, 0.3962264f}, {0.9509434f, 0.7735849f, 0.86415094f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set39{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}, {0.954717f, 0.6792453f, 0.36981133f}, {0.6754717f, 0.83773583f, 0.3962264f}, {0.9509434f, 0.7735849f, 0.86415094f}, {0.8188679f, 0.8188679f, 0.8188679f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set310{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}, {0.954717f, 0.6792453f, 0.36981133f}, {0.6754717f, 0.83773583f, 0.3962264f}, {0.9509434f, 0.7735849f, 0.86415094f}, {0.8188679f, 0.8188679f, 0.8188679f}, {0.709434f, 0.48301888f, 0.71320754f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set311{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}, {0.954717f, 0.6792453f, 0.36981133f}, {0.6754717f, 0.83773583f, 0.3962264f}, {0.9509434f, 0.7735849f, 0.86415094f}, {0.8188679f, 0.8188679f, 0.8188679f}, {0.709434f, 0.48301888f, 0.71320754f}, {0.76981133f, 0.8867925f, 0.7433962f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Set312{
        private final float[][] cols = new float[][]{{0.53207546f, 0.79622644f, 0.7509434f}, {0.9622642f, 0.9622642f, 0.6754717f}, {0.7169811f, 0.7018868f, 0.8226415f}, {0.94716984f, 0.48301888f, 0.4301887f}, {0.48301888f, 0.6679245f, 0.79622644f}, {0.954717f, 0.6792453f, 0.36981133f}, {0.6754717f, 0.83773583f, 0.3962264f}, {0.9509434f, 0.7735849f, 0.86415094f}, {0.8188679f, 0.8188679f, 0.8188679f}, {0.709434f, 0.48301888f, 0.71320754f}, {0.76981133f, 0.8867925f, 0.7433962f}, {0.9622642f, 0.8943396f, 0.41886792f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.QUALITATIVE;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral3{
        private final float[][] cols = new float[][]{{0.9509434f, 0.53207546f, 0.33584905f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.5773585f, 0.8037736f, 0.5584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral4{
        private final float[][] cols = new float[][]{{0.8113208f, 0.094339624f, 0.10566038f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.64528304f, 0.83396226f, 0.61886793f}, {0.16226415f, 0.49433962f, 0.7018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral5{
        private final float[][] cols = new float[][]{{0.8113208f, 0.094339624f, 0.10566038f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.64528304f, 0.83396226f, 0.61886793f}, {0.16226415f, 0.49433962f, 0.7018868f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral6{
        private final float[][] cols = new float[][]{{0.8037736f, 0.23396227f, 0.2981132f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.8679245f, 0.9245283f, 0.5735849f}, {0.5773585f, 0.8037736f, 0.5584906f}, {0.18867925f, 0.51320755f, 0.71320754f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral7{
        private final float[][] cols = new float[][]{{0.8037736f, 0.23396227f, 0.2981132f}, {0.9509434f, 0.53207546f, 0.33584905f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.8679245f, 0.9245283f, 0.5735849f}, {0.5773585f, 0.8037736f, 0.5584906f}, {0.18867925f, 0.51320755f, 0.71320754f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral8{
        private final float[][] cols = new float[][]{{0.8037736f, 0.23396227f, 0.2981132f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.8679245f, 0.9245283f, 0.5735849f}, {0.64528304f, 0.83396226f, 0.61886793f}, {0.38490567f, 0.73207545f, 0.6226415f}, {0.18867925f, 0.51320755f, 0.71320754f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral9{
        private final float[][] cols = new float[][]{{0.8037736f, 0.23396227f, 0.2981132f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.8679245f, 0.9245283f, 0.5735849f}, {0.64528304f, 0.83396226f, 0.61886793f}, {0.38490567f, 0.73207545f, 0.6226415f}, {0.18867925f, 0.51320755f, 0.71320754f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral10{
        private final float[][] cols = new float[][]{{0.5962264f, 0.003773585f, 0.24905661f}, {0.8037736f, 0.23396227f, 0.2981132f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.8679245f, 0.9245283f, 0.5735849f}, {0.64528304f, 0.83396226f, 0.61886793f}, {0.38490567f, 0.73207545f, 0.6226415f}, {0.18867925f, 0.51320755f, 0.71320754f}, {0.354717f, 0.2981132f, 0.61132073f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    Spectral11{
        private final float[][] cols = new float[][]{{0.5962264f, 0.003773585f, 0.24905661f}, {0.8037736f, 0.23396227f, 0.2981132f}, {0.92075473f, 0.41132075f, 0.25283018f}, {0.954717f, 0.65660375f, 0.36603773f}, {0.95849055f, 0.84528303f, 0.5245283f}, {0.9622642f, 0.9622642f, 0.72075474f}, {0.8679245f, 0.9245283f, 0.5735849f}, {0.64528304f, 0.83396226f, 0.61886793f}, {0.38490567f, 0.73207545f, 0.6226415f}, {0.18867925f, 0.51320755f, 0.71320754f}, {0.354717f, 0.2981132f, 0.61132073f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.DIVERGING;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGn3{
        private final float[][] cols = new float[][]{{0.9320755f, 0.9509434f, 0.6981132f}, {0.6528302f, 0.83396226f, 0.53584903f}, {0.18490566f, 0.61509436f, 0.31698114f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGn4{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.73207545f, 0.8679245f, 0.5773585f}, {0.4528302f, 0.7471698f, 0.45660377f}, {0.13207547f, 0.49811321f, 0.25283018f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGn5{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.73207545f, 0.8679245f, 0.5773585f}, {0.4528302f, 0.7471698f, 0.45660377f}, {0.18490566f, 0.61509436f, 0.31698114f}, {0.0f, 0.39245284f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGn6{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.8188679f, 0.9056604f, 0.61509436f}, {0.6528302f, 0.83396226f, 0.53584903f}, {0.4528302f, 0.7471698f, 0.45660377f}, {0.18490566f, 0.61509436f, 0.31698114f}, {0.0f, 0.39245284f, 0.20754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGn7{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.8188679f, 0.9056604f, 0.61509436f}, {0.6528302f, 0.83396226f, 0.53584903f}, {0.4528302f, 0.7471698f, 0.45660377f}, {0.24528302f, 0.64528304f, 0.3509434f}, {0.13207547f, 0.49811321f, 0.25283018f}, {0.0f, 0.33962265f, 0.18867925f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGn8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.86415094f}, {0.9320755f, 0.9509434f, 0.6981132f}, {0.8188679f, 0.9056604f, 0.61509436f}, {0.6528302f, 0.83396226f, 0.53584903f}, {0.4528302f, 0.7471698f, 0.45660377f}, {0.24528302f, 0.64528304f, 0.3509434f}, {0.13207547f, 0.49811321f, 0.25283018f}, {0.0f, 0.33962265f, 0.18867925f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGn9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.86415094f}, {0.9320755f, 0.9509434f, 0.6981132f}, {0.8188679f, 0.9056604f, 0.61509436f}, {0.6528302f, 0.83396226f, 0.53584903f}, {0.4528302f, 0.7471698f, 0.45660377f}, {0.24528302f, 0.64528304f, 0.3509434f}, {0.13207547f, 0.49811321f, 0.25283018f}, {0.0f, 0.39245284f, 0.20754717f}, {0.0f, 0.26037735f, 0.15471698f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGnBu3{
        private final float[][] cols = new float[][]{{0.8943396f, 0.9358491f, 0.6679245f}, {0.47924528f, 0.7735849f, 0.7056604f}, {0.16603774f, 0.47924528f, 0.69433963f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGnBu4{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.60754716f, 0.8226415f, 0.6792453f}, {0.24528302f, 0.68679243f, 0.73962265f}, {0.12830189f, 0.354717f, 0.6339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGnBu5{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.60754716f, 0.8226415f, 0.6792453f}, {0.24528302f, 0.68679243f, 0.73962265f}, {0.16603774f, 0.47924528f, 0.69433963f}, {0.13962264f, 0.19622642f, 0.5584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGnBu6{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.7509434f, 0.8792453f, 0.6792453f}, {0.47924528f, 0.7735849f, 0.7056604f}, {0.24528302f, 0.68679243f, 0.73962265f}, {0.16603774f, 0.47924528f, 0.69433963f}, {0.13962264f, 0.19622642f, 0.5584906f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGnBu7{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.7509434f, 0.8792453f, 0.6792453f}, {0.47924528f, 0.7735849f, 0.7056604f}, {0.24528302f, 0.68679243f, 0.73962265f}, {0.109433964f, 0.5471698f, 0.7245283f}, {0.12830189f, 0.354717f, 0.6339623f}, {0.04528302f, 0.16603774f, 0.49811321f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGnBu8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.8188679f}, {0.8943396f, 0.9358491f, 0.6679245f}, {0.7509434f, 0.8792453f, 0.6792453f}, {0.47924528f, 0.7735849f, 0.7056604f}, {0.24528302f, 0.68679243f, 0.73962265f}, {0.109433964f, 0.5471698f, 0.7245283f}, {0.12830189f, 0.354717f, 0.6339623f}, {0.04528302f, 0.16603774f, 0.49811321f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlGnBu9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.8188679f}, {0.8943396f, 0.9358491f, 0.6679245f}, {0.7509434f, 0.8792453f, 0.6792453f}, {0.47924528f, 0.7735849f, 0.7056604f}, {0.24528302f, 0.68679243f, 0.73962265f}, {0.109433964f, 0.5471698f, 0.7245283f}, {0.12830189f, 0.354717f, 0.6339623f}, {0.13962264f, 0.19622642f, 0.5584906f}, {0.03018868f, 0.109433964f, 0.33207548f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrBr3{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9320755f, 0.709434f}, {0.95849055f, 0.73962265f, 0.2981132f}, {0.8188679f, 0.35849056f, 0.05283019f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrBr4{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.8f}, {0.95849055f, 0.8188679f, 0.53584903f}, {0.95849055f, 0.5773585f, 0.15471698f}, {0.76981133f, 0.28679246f, 0.00754717f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrBr5{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.8f}, {0.95849055f, 0.8188679f, 0.53584903f}, {0.95849055f, 0.5773585f, 0.15471698f}, {0.8188679f, 0.35849056f, 0.05283019f}, {0.5773585f, 0.19622642f, 0.01509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrBr6{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.8f}, {0.95849055f, 0.8566038f, 0.5471698f}, {0.95849055f, 0.73962265f, 0.2981132f}, {0.95849055f, 0.5773585f, 0.15471698f}, {0.8188679f, 0.35849056f, 0.05283019f}, {0.5773585f, 0.19622642f, 0.01509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrBr7{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.8f}, {0.95849055f, 0.8566038f, 0.5471698f}, {0.95849055f, 0.73962265f, 0.2981132f}, {0.95849055f, 0.5773585f, 0.15471698f}, {0.89056605f, 0.42264152f, 0.0754717f}, {0.76981133f, 0.28679246f, 0.00754717f}, {0.5283019f, 0.16981132f, 0.01509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrBr8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.86415094f}, {0.9622642f, 0.9320755f, 0.709434f}, {0.95849055f, 0.8566038f, 0.5471698f}, {0.95849055f, 0.73962265f, 0.2981132f}, {0.95849055f, 0.5773585f, 0.15471698f}, {0.89056605f, 0.42264152f, 0.0754717f}, {0.76981133f, 0.28679246f, 0.00754717f}, {0.5283019f, 0.16981132f, 0.01509434f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrBr9{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.86415094f}, {0.9622642f, 0.9320755f, 0.709434f}, {0.95849055f, 0.8566038f, 0.5471698f}, {0.95849055f, 0.73962265f, 0.2981132f}, {0.95849055f, 0.5773585f, 0.15471698f}, {0.89056605f, 0.42264152f, 0.0754717f}, {0.76981133f, 0.28679246f, 0.00754717f}, {0.5773585f, 0.19622642f, 0.01509434f}, {0.38490567f, 0.13962264f, 0.02264151f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrRd3{
        private final float[][] cols = new float[][]{{0.9622642f, 0.8943396f, 0.6037736f}, {0.95849055f, 0.6716981f, 0.28679246f}, {0.9056604f, 0.22264151f, 0.12075472f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrRd4{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.6716981f}, {0.95849055f, 0.76981133f, 0.34716982f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.8566038f, 0.09811321f, 0.10566038f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrRd5{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.6716981f}, {0.95849055f, 0.76981133f, 0.34716982f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.9056604f, 0.22264151f, 0.12075472f}, {0.71320754f, 0.0f, 0.14339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrRd6{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.6716981f}, {0.95849055f, 0.8188679f, 0.44528303f}, {0.95849055f, 0.6716981f, 0.28679246f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.9056604f, 0.22264151f, 0.12075472f}, {0.71320754f, 0.0f, 0.14339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrRd7{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.6716981f}, {0.95849055f, 0.8188679f, 0.44528303f}, {0.95849055f, 0.6716981f, 0.28679246f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.9509434f, 0.29433963f, 0.15849057f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.6679245f, 0.0f, 0.14339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    }
    ,
    YlOrRd8{
        private final float[][] cols = new float[][]{{0.9622642f, 0.9622642f, 0.76981133f}, {0.9622642f, 0.8943396f, 0.6037736f}, {0.95849055f, 0.8188679f, 0.44528303f}, {0.95849055f, 0.6716981f, 0.28679246f}, {0.954717f, 0.53207546f, 0.2264151f}, {0.9509434f, 0.29433963f, 0.15849057f}, {0.8566038f, 0.09811321f, 0.10566038f}, {0.6679245f, 0.0f, 0.14339623f}};

        @Override
        public void apply(float x, float[] out) {
            int i = Math.min((int)(x * (float)this.cols.length), this.cols.length - 1);
            float[] col = this.cols[i];
            out[0] = col[0];
            out[1] = col[1];
            out[2] = col[2];
        }

        @Override
        public Type type() {
            return Type.SEQUENTIAL;
        }

        @Override
        public Mode mode() {
            return Mode.DISCRETE;
        }
    };


    public abstract void apply(float var1, float[] var2);

    public Float[] apply(float val) {
        float[] out = new float[3];
        this.apply(val, out);
        return new Float[]{Float.valueOf(out[0]), Float.valueOf(out[1]), Float.valueOf(out[2])};
    }

    public MBFImage apply(FImage img) {
        float[] pixOut = new float[3];
        int width = img.width;
        int height = img.height;
        float[][] pix = img.pixels;
        MBFImage out = new MBFImage(width, height, ColourSpace.RGB);
        float[][] r = ((FImage)out.getBand((int)0)).pixels;
        float[][] g = ((FImage)out.getBand((int)1)).pixels;
        float[][] b = ((FImage)out.getBand((int)2)).pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.apply(pix[y][x], pixOut);
                r[y][x] = pixOut[0];
                g[y][x] = pixOut[1];
                b[y][x] = pixOut[2];
            }
        }
        return out;
    }

    public abstract Type type();

    public abstract Mode mode();

    public MBFImage visualise(int width, int height) {
        FImage f = new FImage(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                f.pixels[y][x] = (float)x / (float)width;
            }
        }
        return this.apply(f);
    }

    public MBFImage visualise() {
        return this.visualise(256, 100);
    }

    public Float[][] generateColours(int ncolours) {
        int i;
        Float[][] cm = new Float[ncolours][];
        cm[0] = this.apply(0.0f);
        cm[ncolours - 1] = this.apply(1.0f);
        boolean same = false;
        for (i = 0; i < cm[0].length; ++i) {
            if (!((double)Math.abs(cm[0][i].floatValue() - cm[ncolours - 1][i].floatValue()) < 1.0E-5)) continue;
            same = true;
            break;
        }
        if (same) {
            for (i = 1; i < ncolours; ++i) {
                cm[i] = this.apply((float)i / (float)ncolours);
            }
        } else {
            for (i = 1; i < ncolours - 1; ++i) {
                cm[i] = this.apply((float)i / (float)(ncolours - 1));
            }
        }
        return cm;
    }

    public static enum Mode {
        INTERPOLATED,
        DISCRETE;

    }

    public static enum Type {
        SEQUENTIAL,
        QUALITATIVE,
        DIVERGING;

    }
}

