/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.keypoints;

import Jama.Matrix;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.ByteFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.feature.local.keypoints.KeypointLocation;
import org.openimaj.io.VariableLength;

public class SIFTGeoKeypoint
implements LocalFeature<SIFTGeoLocation, ByteFV>,
VariableLength,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public SIFTGeoLocation location = new SIFTGeoLocation();
    public byte[] descriptor;

    public SIFTGeoKeypoint(int len) {
        this.descriptor = new byte[len];
    }

    public SIFTGeoKeypoint(float x, float y, float orientation, float scale, float cornerness, Matrix affine, byte[] descriptor) {
        this.location.x = x;
        this.location.y = y;
        this.location.orientation = orientation;
        this.location.scale = scale;
        this.location.cornerness = cornerness;
        this.location.affine = affine;
        this.descriptor = descriptor;
    }

    public void readASCII(Scanner in) throws IOException {
        this.location.readASCII(in);
        int len = in.nextInt();
        this.descriptor = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.descriptor[i] = (byte)(in.nextInt() - 128);
        }
    }

    public String asciiHeader() {
        return "";
    }

    public void readBinary(DataInput in) throws IOException {
        this.location.readBinary(in);
        byte[] array = new byte[4];
        in.readFully(array);
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int len = buffer.getInt();
        this.descriptor = new byte[len];
        for (int i = 0; i < this.descriptor.length; ++i) {
            this.descriptor[i] = (byte)(in.readUnsignedByte() - 128);
        }
    }

    public byte[] binaryHeader() {
        return new byte[0];
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.location.writeASCII(out);
        out.format("%d\n", this.descriptor.length);
        for (int i = 0; i < this.descriptor.length; ++i) {
            out.format("%d ", this.descriptor[i] + 128);
        }
        out.append("\n");
    }

    public void writeBinary(DataOutput out) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(40 + this.descriptor.length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.location.writeBinary(buffer);
        buffer.putInt(this.descriptor.length);
        for (int i = 0; i < this.descriptor.length; ++i) {
            buffer.put((byte)(this.descriptor[i] + 128 & 0xFF));
        }
        out.write(buffer.array());
    }

    public ByteFV getFeatureVector() {
        return new ByteFV(this.descriptor);
    }

    public SIFTGeoLocation getLocation() {
        return this.location;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeASCII(new PrintWriter(sw));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    public static LocalFeatureList<SIFTGeoKeypoint> read(File file) throws IOException {
        return SIFTGeoKeypoint.read(new BufferedInputStream(new FileInputStream(file)));
    }

    public static LocalFeatureList<SIFTGeoKeypoint> read(InputStream stream) throws IOException {
        return SIFTGeoKeypoint.read(new DataInputStream(stream));
    }

    public static LocalFeatureList<SIFTGeoKeypoint> read(DataInputStream stream) throws IOException {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList();
        try {
            while (true) {
                SIFTGeoKeypoint kp = new SIFTGeoKeypoint(0);
                kp.readBinary(stream);
                keys.add((Object)kp);
            }
        }
        catch (EOFException eof) {
            return keys;
        }
    }

    public static void write(List<SIFTGeoKeypoint> keys, File file) throws IOException {
        SIFTGeoKeypoint.write(keys, new FileOutputStream(file));
    }

    public static void write(List<SIFTGeoKeypoint> keys, OutputStream stream) throws IOException {
        SIFTGeoKeypoint.write(keys, new DataOutputStream(stream));
    }

    public static void write(List<SIFTGeoKeypoint> keys, DataOutputStream stream) throws IOException {
        for (SIFTGeoKeypoint k : keys) {
            k.writeBinary(stream);
        }
    }

    public class SIFTGeoLocation
    extends KeypointLocation {
        private static final long serialVersionUID = 1L;
        private static final int NUM_BYTES = 36;
        public float cornerness;
        public Matrix affine;

        public SIFTGeoLocation(float x, float y, float orientation, float scale, float cornerness, Matrix affine) {
            super(x, y, scale, orientation);
            this.cornerness = cornerness;
            this.affine = affine;
        }

        public SIFTGeoLocation() {
            this.affine = Matrix.identity((int)2, (int)2);
        }

        @Override
        public void writeBinary(DataOutput out) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(36);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeBinary(buffer);
        }

        private void writeBinary(ByteBuffer buffer) {
            buffer.putFloat(this.x);
            buffer.putFloat(this.y);
            buffer.putFloat(this.scale);
            buffer.putFloat(this.orientation);
            buffer.putFloat((float)this.affine.get(0, 0));
            buffer.putFloat((float)this.affine.get(0, 1));
            buffer.putFloat((float)this.affine.get(1, 0));
            buffer.putFloat((float)this.affine.get(1, 1));
            buffer.putFloat(this.cornerness);
        }

        @Override
        public void writeASCII(PrintWriter out) throws IOException {
            out.format("%4.2f %4.2f %4.2f %4.3f %4.3f %4.3f %4.3f %4.3f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.scale), Float.valueOf(this.orientation), Float.valueOf((float)this.affine.get(0, 0)), Float.valueOf((float)this.affine.get(0, 1)), Float.valueOf((float)this.affine.get(1, 0)), Float.valueOf((float)this.affine.get(1, 1)));
            out.println();
        }

        @Override
        public void readBinary(DataInput in) throws IOException {
            byte[] array = new byte[36];
            in.readFully(array);
            ByteBuffer buffer = ByteBuffer.wrap(array);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.readBinary(buffer);
        }

        private void readBinary(ByteBuffer buffer) {
            this.x = buffer.getFloat();
            this.y = buffer.getFloat();
            this.scale = buffer.getFloat();
            this.orientation = buffer.getFloat();
            this.affine.set(0, 0, (double)buffer.getFloat());
            this.affine.set(0, 1, (double)buffer.getFloat());
            this.affine.set(1, 0, (double)buffer.getFloat());
            this.affine.set(1, 1, (double)buffer.getFloat());
            this.cornerness = buffer.getFloat();
        }

        @Override
        public void readASCII(Scanner in) throws IOException {
            this.x = Float.parseFloat(in.next());
            this.y = Float.parseFloat(in.next());
            this.scale = Float.parseFloat(in.next());
            this.orientation = Float.parseFloat(in.next());
            this.affine.set(0, 0, (double)Float.parseFloat(in.next()));
            this.affine.set(0, 1, (double)Float.parseFloat(in.next()));
            this.affine.set(1, 0, (double)Float.parseFloat(in.next()));
            this.affine.set(1, 1, (double)Float.parseFloat(in.next()));
            this.cornerness = Float.parseFloat(in.next());
        }

        @Override
        public byte[] binaryHeader() {
            return "".getBytes();
        }

        @Override
        public String asciiHeader() {
            return "";
        }

        @Override
        public Float getOrdinate(int dimension) {
            float[] pos = new float[]{this.x, this.y, this.scale, this.orientation, (float)this.affine.get(0, 0), (float)this.affine.get(0, 1), (float)this.affine.get(1, 0), (float)this.affine.get(1, 1)};
            return Float.valueOf(pos[dimension]);
        }
    }
}

