/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.keypoints;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.openimaj.feature.FloatFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.feature.local.keypoints.KeypointLocation;
import org.openimaj.io.VariableLength;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.ScaleSpacePoint;

public class FloatKeypoint
implements Serializable,
ScaleSpacePoint,
LocalFeature<KeypointLocation, FloatFV>,
VariableLength,
Cloneable {
    static final long serialVersionUID = 1234554345L;
    private static final int DEFAULT_LENGTH = 128;
    public float[] vector;
    public float ori;
    public float scale;
    public float x;
    public float y;

    public FloatKeypoint() {
        this.vector = new float[128];
    }

    public FloatKeypoint(int length) {
        if (length < 0) {
            length = 128;
        }
        this.vector = new float[length];
    }

    public FloatKeypoint(float x, float y, float ori, float scale, float[] ivec) {
        this.x = x;
        this.y = y;
        this.ori = ori;
        this.scale = scale;
        this.vector = ivec;
    }

    public FloatKeypoint(FloatKeypoint k) {
        this(k.x, k.y, k.ori, k.scale, Arrays.copyOf(k.vector, k.vector.length));
    }

    public FloatKeypoint(Keypoint k) {
        this.setLocation(k.getLocation());
        this.vector = new float[k.ivec.length];
        for (int i = 0; i < this.vector.length; ++i) {
            this.vector[i] = k.ivec[i] + 128;
        }
    }

    public Float getOrdinate(int dimension) {
        if (dimension == 0) {
            return Float.valueOf(this.x);
        }
        if (dimension == 1) {
            return Float.valueOf(this.y);
        }
        if (dimension == 2) {
            return Float.valueOf(this.scale);
        }
        return null;
    }

    public int getDimensions() {
        return 3;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public String toString() {
        return "Keypoint(" + this.x + ", " + this.y + ", " + this.scale + ", " + this.ori + ")";
    }

    public boolean locationEquals(Object obj) {
        if (obj instanceof FloatKeypoint) {
            FloatKeypoint kobj = (FloatKeypoint)obj;
            if (kobj.x == this.x && kobj.y == this.y && kobj.scale == this.scale) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatKeypoint) {
            FloatKeypoint kobj = (FloatKeypoint)obj;
            if (kobj.x == this.x && kobj.y == this.y && kobj.scale == this.scale && Arrays.equals(this.vector, kobj.vector)) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + Float.floatToIntBits(this.y);
        hash = hash * 31 + Float.floatToIntBits(this.x);
        hash = hash * 31 + Float.floatToIntBits(this.scale);
        return hash;
    }

    public FloatKeypoint clone() {
        FloatKeypoint clone = new FloatKeypoint();
        clone.x = this.x;
        clone.ori = this.ori;
        clone.y = this.y;
        clone.scale = this.scale;
        clone.vector = new float[this.vector.length];
        System.arraycopy(this.vector, 0, clone.vector, 0, this.vector.length);
        return clone;
    }

    public void copyFrom(Point2d p) {
        this.setX(p.getX());
        this.setY(p.getY());
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.getLocation().writeBinary(out);
        out.writeInt(this.vector.length);
        for (int i = 0; i < this.vector.length; ++i) {
            out.writeFloat(this.vector[i]);
        }
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.getLocation().writeASCII(out);
        for (int i = 0; i < this.vector.length; ++i) {
            if (i > 0 && i % 20 == 0) {
                out.println();
            }
            out.print(" " + this.vector[i]);
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        KeypointLocation l = this.getLocation();
        l.readBinary(in);
        this.setLocation(l);
        this.vector = new float[in.readInt()];
        for (int i = 0; i < this.vector.length; ++i) {
            this.vector[i] = in.readFloat();
        }
    }

    public void readASCII(Scanner in) throws IOException {
        KeypointLocation l = this.getLocation();
        l.readASCII(in);
        this.setLocation(l);
        int i = 0;
        while (i < this.vector.length) {
            String line = in.nextLine();
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                this.vector[i] = Float.parseFloat(st.nextToken());
                ++i;
            }
        }
    }

    public byte[] binaryHeader() {
        return "".getBytes();
    }

    public String asciiHeader() {
        return "";
    }

    public FloatFV getFeatureVector() {
        return new FloatFV(this.vector);
    }

    public KeypointLocation getLocation() {
        return new KeypointLocation(this.x, this.y, this.ori, this.scale);
    }

    public void setLocation(KeypointLocation location) {
        this.x = location.x;
        this.y = location.y;
        this.scale = location.scale;
        this.ori = location.orientation;
    }

    public void translate(float x, float y) {
        this.x += x;
        this.y += y;
    }

    public FloatKeypoint transform(Matrix transform) {
        float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY() + (float)transform.get(0, 2);
        float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY() + (float)transform.get(1, 2);
        float zt = (float)transform.get(2, 0) * this.getX() + (float)transform.get(2, 1) * this.getY() + (float)transform.get(2, 2);
        return new FloatKeypoint(xt /= zt, yt /= zt, this.ori, this.scale, (float[])this.vector.clone());
    }

    public Point2d minus(Point2d a) {
        FloatKeypoint kp = this.clone();
        kp.x = this.x - (float)((int)a.getX());
        kp.y = this.y - (float)((int)a.getY());
        return null;
    }

    public void translate(Point2d v) {
        this.translate(v.getX(), v.getY());
    }

    public Point2d copy() {
        return this.clone();
    }

    public static MemoryLocalFeatureList<FloatKeypoint> convert(List<? extends Keypoint> keys) {
        MemoryLocalFeatureList out = new MemoryLocalFeatureList();
        for (Keypoint keypoint : keys) {
            out.add((Object)new FloatKeypoint(keypoint));
        }
        return out;
    }

    public void setOrdinate(int dimension, Number value) {
        if (dimension == 0) {
            this.x = value.floatValue();
        }
        if (dimension == 1) {
            this.y = value.floatValue();
        }
    }
}

