/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.feature.local.interest.AbstractStructureTensorIPD;

public class HarrisIPD
extends AbstractStructureTensorIPD {
    protected float eigenRatio = 0.04f;

    public HarrisIPD(float detectionScale, float integrationScale) {
        this(detectionScale, integrationScale, 0.04f);
    }

    public HarrisIPD(float detectionScale, float integrationScale, float eigenRatio) {
        super(detectionScale, integrationScale);
        this.eigenRatio = eigenRatio;
    }

    public HarrisIPD() {
        this(2.25f, 6.25f, 0.01f);
    }

    public HarrisIPD(float f) {
        super(f);
    }

    @Override
    public FImage createInterestPointMap() {
        FImage det = ((FImage)this.lxmxblur.multiply((Image)this.lymyblur)).subtract((FImage)this.lxmyblur.multiply((Image)this.lxmyblur));
        FImage trace = this.lxmxblur.add(this.lymyblur);
        FImage traceSq = (FImage)trace.multiply((Image)trace);
        return det.subtract(traceSq.multiply(Float.valueOf(this.eigenRatio)));
    }

    @Override
    public HarrisIPD clone() {
        HarrisIPD a = (HarrisIPD)super.clone();
        a.eigenRatio = this.eigenRatio;
        return a;
    }
}

