/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.pyramid;

import Jama.Matrix;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.feature.local.detector.pyramid.BasicOctaveExtremaFinder;

@References(references={@Reference(type=ReferenceType.Inproceedings, author={"Matthew Brown", "D Lowe"}, title="Invariant Features from Interest Point Groups", year="2002", booktitle="BMVC 2002: 13th British Machine Vision Conference", pages={"253", "", "262"}, month="September"), @Reference(type=ReferenceType.Article, author={"David Lowe"}, title="Distinctive image features from scale-invariant keypoints", year="2004", journal="IJCV", pages={"91", "110"}, month="January", number="2", volume="60")})
public class InterpolatingOctaveExtremaFinder
extends BasicOctaveExtremaFinder {
    public static final int DEFAULT_INTERPOLATION_ITERATIONS = 5;
    protected int numInterpolationIterations;
    private boolean[][] map;
    private int currentIteration;

    public InterpolatingOctaveExtremaFinder() {
        this(0.04f, 10.0f, 5);
    }

    public InterpolatingOctaveExtremaFinder(float magnitudeThreshold) {
        this(magnitudeThreshold, 10.0f, 5);
    }

    public InterpolatingOctaveExtremaFinder(float magnitudeThreshold, float eigenvalueRatio, int numInterpolationIterations) {
        super(magnitudeThreshold, eigenvalueRatio);
        this.numInterpolationIterations = numInterpolationIterations;
    }

    @Override
    public void process(GaussianOctave<FImage> octave) {
        this.map = new boolean[((FImage[])octave.images)[0].height][((FImage[])octave.images)[0].width];
        super.process(octave);
    }

    @Override
    protected void processExtrema(FImage[] dogs, int s, int x, int y, float octSize) {
        this.currentIteration = 0;
        this.processExtremaInternal(dogs, s, x, y, octSize);
    }

    protected void processExtremaInternal(FImage[] dogs, int s, int x, int y, float octSize) {
        int newy = y;
        int newx = x;
        FitResult fit = this.fitQuadratic3D(dogs, s, x, y);
        if (fit.offset.get(1, 0) > 0.5 && y < dogs[0].height - ((GaussianPyramidOptions)((GaussianOctave)this.octave).options).getBorderPixels()) {
            ++newy;
        }
        if (fit.offset.get(1, 0) < -0.5 && y > ((GaussianPyramidOptions)((GaussianOctave)this.octave).options).getBorderPixels()) {
            --newy;
        }
        if (fit.offset.get(2, 0) > 0.5 && x < dogs[0].width - ((GaussianPyramidOptions)((GaussianOctave)this.octave).options).getBorderPixels()) {
            ++newx;
        }
        if (fit.offset.get(2, 0) < -0.5 && x > ((GaussianPyramidOptions)((GaussianOctave)this.octave).options).getBorderPixels()) {
            --newx;
        }
        if (this.currentIteration < this.numInterpolationIterations && (newy != y || newx != x)) {
            ++this.currentIteration;
            this.processExtremaInternal(dogs, s, newx, newy, octSize);
            return;
        }
        if (Math.abs(fit.offset.get(0, 0)) > 1.5 || Math.abs(fit.offset.get(1, 0)) > 1.5 || Math.abs(fit.offset.get(2, 0)) > 1.5 || Math.abs(fit.peakval) < this.normMagnitudeScales) {
            return;
        }
        if (this.map[y][x]) {
            return;
        }
        this.map[y][x] = true;
        float octaveScale = ((GaussianPyramidOptions)((GaussianOctave)this.octave).options).getInitialSigma() * (float)Math.pow(2.0, ((double)s + fit.offset.get(0, 0)) / (double)((GaussianPyramidOptions)((GaussianOctave)this.octave).options).getScales());
        if (this.listener != null) {
            this.listener.foundInterestPoint(this, (float)x + (float)fit.offset.get(2, 0), (float)y + (float)fit.offset.get(1, 0), octaveScale);
        }
    }

    FitResult fitQuadratic3D(FImage[] dogs, int s, int x, int y) {
        float[][] dog0 = dogs[s - 1].pixels;
        float[][] dog1 = dogs[s].pixels;
        float[][] dog2 = dogs[s + 1].pixels;
        Matrix H = new Matrix(3, 3);
        H.set(0, 0, (double)dog0[y][x] - 2.0 * (double)dog1[y][x] + (double)dog2[y][x]);
        H.set(0, 1, (double)(dog2[y + 1][x] - dog2[y - 1][x] - (dog0[y + 1][x] - dog0[y - 1][x])) / 4.0);
        H.set(0, 2, (double)(dog2[y][x + 1] - dog2[y][x - 1] - (dog0[y][x + 1] - dog0[y][x - 1])) / 4.0);
        H.set(1, 0, H.get(0, 1));
        H.set(1, 1, (double)dog1[y - 1][x] - 2.0 * (double)dog1[y][x] + (double)dog1[y + 1][x]);
        H.set(1, 2, (double)(dog1[y + 1][x + 1] - dog1[y + 1][x - 1] - (dog1[y - 1][x + 1] - dog1[y - 1][x - 1])) / 4.0);
        H.set(2, 0, H.get(0, 2));
        H.set(2, 1, H.get(1, 2));
        H.set(2, 2, (double)dog1[y][x - 1] - 2.0 * (double)dog1[y][x] + (double)dog1[y][x + 1]);
        Matrix gM = new Matrix((double[][])new double[][]{{(dog2[y][x] - dog0[y][x]) / 2.0f}, {(dog1[y + 1][x] - dog1[y - 1][x]) / 2.0f}, {(dog1[y][x + 1] - dog1[y][x - 1]) / 2.0f}});
        Matrix offsetM = H.solve(gM.times(-1.0));
        FitResult result = new FitResult();
        result.offset = offsetM;
        float dp = (float)(offsetM.get(0, 0) * gM.get(0, 0) + offsetM.get(1, 0) * gM.get(1, 0) + offsetM.get(2, 0) * gM.get(2, 0));
        result.peakval = dog1[y][x] + 0.5f * dp;
        return result;
    }

    class FitResult {
        Matrix offset;
        float peakval;

        FitResult() {
        }
    }
}

