/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.ipd.finder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.detector.ipd.finder.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.interest.IPDSelectionMode;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.MultiscaleInterestPointDetector;

public class LoggingOctaveInterestPointFinder<T extends InterestPointData>
extends OctaveInterestPointFinder<T> {
    private HashMap<String, Integer> scalePoints = new HashMap();
    private ArrayList<String> scales = new ArrayList();

    public LoggingOctaveInterestPointFinder(MultiscaleInterestPointDetector<T> detector, IPDSelectionMode selectionMode) {
        super(detector, selectionMode);
    }

    @Override
    protected void processOctaveLevelPoints(FImage fImage, List<T> points, float currentScale, float octaveSize) {
        super.processOctaveLevelPoints(fImage, points, currentScale, octaveSize);
        String key = String.format("%f-%f", Float.valueOf(currentScale * octaveSize), Float.valueOf(octaveSize));
        this.scalePoints.put(key, points.size());
        this.scales.add(key);
    }

    private void printScalePoints() {
        for (String scale : this.scales) {
            Integer entry = this.scalePoints.get(scale);
            System.out.format("%s,%d\n", scale, entry);
        }
    }

    @Override
    public void finish() {
        this.printScalePoints();
    }
}

