/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.ipd.finder;

import java.util.Iterator;
import java.util.TreeSet;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.image.feature.local.detector.ipd.finder.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.interest.IPDSelectionMode;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.MultiscaleInterestPointDetector;
import org.openimaj.image.feature.local.keypoints.InterestPointKeypoint;
import org.openimaj.math.geometry.shape.Ellipse;

public class CharacteristicOctaveInterestPointFinder<T extends InterestPointData>
extends OctaveInterestPointFinder<T> {
    private static final double DEFAULT_MAX_DISTANCE = 4.0;
    private static final double DEFAULT_MAX_ROTATION = 0.2617993877991494;
    private static final double DEFAULT_MAX_AXIS_RATIO = 0.1;
    public double maxDistance = 4.0;
    public double maxRotation = 0.2617993877991494;
    public double maxAxisRatio = 0.1;

    public CharacteristicOctaveInterestPointFinder(MultiscaleInterestPointDetector<T> detector, IPDSelectionMode selectionMode) {
        super(detector, selectionMode);
    }

    @Override
    public void finish() {
        LocalFeatureList locatedFeatures = this.listener.getFeatures();
        TreeSet<Integer> toRemove = new TreeSet<Integer>();
        for (int i = 0; i < locatedFeatures.size(); ++i) {
            InterestPointKeypoint kp1 = (InterestPointKeypoint)locatedFeatures.get(i);
            for (int j = i + 1; j < locatedFeatures.size(); ++j) {
                InterestPointKeypoint kp2 = (InterestPointKeypoint)locatedFeatures.get(j);
                if (!this.similarTo(kp1, kp2)) continue;
                if (((InterestPointData)((Object)kp1.location)).score >= ((InterestPointData)((Object)kp2.location)).score) {
                    toRemove.add(j);
                    continue;
                }
                toRemove.add(i);
            }
        }
        int nRemove = 0;
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            locatedFeatures.remove(index - nRemove++);
        }
    }

    private boolean similarTo(InterestPointKeypoint<T> kp1, InterestPointKeypoint<T> kp2) {
        boolean similar = true;
        boolean bl = similar = Math.sqrt(Math.pow(kp1.x - kp2.x, 2.0) + Math.pow(kp1.y - kp2.y, 2.0)) < this.maxDistance;
        if (!similar) {
            return false;
        }
        Ellipse e1 = ((InterestPointData)((Object)kp1.location)).getEllipse();
        Ellipse e2 = ((InterestPointData)((Object)kp2.location)).getEllipse();
        boolean bl2 = similar = Math.abs(e1.getRotation() - e2.getRotation()) < this.maxRotation;
        if (!similar) {
            return false;
        }
        boolean bl3 = similar = Math.abs(e1.getMinor() / e1.getMajor() - e2.getMinor() / e2.getMajor()) < this.maxAxisRatio;
        return similar;
    }
}

