/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.ipd.collector;

import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.detector.ipd.collector.AffineInterestPointKeypoint;
import org.openimaj.image.feature.local.detector.ipd.collector.InterestPointFeatureCollector;
import org.openimaj.image.feature.local.detector.ipd.extractor.InterestPointGradientFeatureExtractor;
import org.openimaj.image.feature.local.engine.ipd.InterestPointImageExtractorProperties;
import org.openimaj.image.feature.local.interest.EllipticInterestPointData;

public class AffineInterestPointFeatureCollector
extends InterestPointFeatureCollector<EllipticInterestPointData> {
    public AffineInterestPointFeatureCollector(InterestPointGradientFeatureExtractor extractor) {
        super(extractor);
    }

    @Override
    public void foundInterestPoint(FImage image, EllipticInterestPointData point) {
        OrientedFeatureVector[] extracted;
        InterestPointImageExtractorProperties<Float, FImage> property = new InterestPointImageExtractorProperties<Float, FImage>(image, point);
        for (OrientedFeatureVector feature : extracted = this.extractor.extractFeature(property)) {
            this.features.add((Object)new AffineInterestPointKeypoint(feature, point.clone()));
        }
    }

    @Override
    public void foundInterestPoint(FImage image, EllipticInterestPointData point, double octaveSize) {
        OrientedFeatureVector[] extracted;
        InterestPointImageExtractorProperties<Float, FImage> property = new InterestPointImageExtractorProperties<Float, FImage>(image, point);
        for (OrientedFeatureVector feature : extracted = this.extractor.extractFeature(property)) {
            point = point.clone();
            point.scale = (float)((double)point.scale * octaveSize);
            point.x = (float)((double)point.x * octaveSize);
            point.y = (float)((double)point.y * octaveSize);
            this.features.add((Object)new AffineInterestPointKeypoint(feature, point.clone()));
        }
    }
}

