/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.extractor;

import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProvider;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProviderFactory;
import org.openimaj.image.feature.local.detector.dog.extractor.AbstractDominantOrientationExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.ScaleSpaceFeatureExtractor;
import org.openimaj.image.feature.local.extraction.GradientScaleSpaceImageExtractorProperties;
import org.openimaj.image.feature.local.extraction.ScaleSpaceImageExtractorProperties;
import org.openimaj.image.processing.convolution.FImageGradients;

public class ColourGradientFeatureExtractor
implements ScaleSpaceFeatureExtractor<OrientedFeatureVector, MBFImage> {
    AbstractDominantOrientationExtractor dominantOrientationExtractor;
    GradientFeatureProviderFactory factory;
    private GradientScaleSpaceImageExtractorProperties<FImage> currentGradientProperties = new GradientScaleSpaceImageExtractorProperties();
    protected MBFImage image;
    protected FImage[] magnitudes;
    protected FImage[] orientations;
    protected float magnification = 12.0f;

    public ColourGradientFeatureExtractor(AbstractDominantOrientationExtractor dominantOrientationExtractor, GradientFeatureProviderFactory factory) {
        this.dominantOrientationExtractor = dominantOrientationExtractor;
        this.factory = factory;
    }

    public ColourGradientFeatureExtractor(AbstractDominantOrientationExtractor dominantOrientationExtractor, GradientFeatureProviderFactory factory, float magnification) {
        this(dominantOrientationExtractor, factory);
        this.magnification = magnification;
    }

    public OrientedFeatureVector[] extractFeature(ScaleSpaceImageExtractorProperties<MBFImage> properties) {
        GradientScaleSpaceImageExtractorProperties<FImage> gprops = this.getCurrentGradientProps(properties);
        float[] dominantOrientations = this.dominantOrientationExtractor.extractFeatureRaw(gprops);
        OrientedFeatureVector[] ret = new OrientedFeatureVector[dominantOrientations.length];
        for (int i = 0; i < dominantOrientations.length; ++i) {
            ret[i] = this.createFeature(dominantOrientations[i]);
        }
        return ret;
    }

    public GradientScaleSpaceImageExtractorProperties<FImage> getCurrentGradientProps(ScaleSpaceImageExtractorProperties<MBFImage> properties) {
        if (properties.image != this.image) {
            int i;
            this.image = (MBFImage)properties.image;
            this.currentGradientProperties.image = (Image)this.image.bands.get(0);
            if (this.currentGradientProperties.orientation == null || this.currentGradientProperties.orientation.height != ((FImage)this.currentGradientProperties.image).height || this.currentGradientProperties.orientation.width != ((FImage)this.currentGradientProperties.image).width) {
                this.currentGradientProperties.orientation = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
                this.currentGradientProperties.magnitude = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
                if (this.magnitudes == null) {
                    this.magnitudes = new FImage[this.image.bands.size() - 1];
                    this.orientations = new FImage[this.image.bands.size() - 1];
                }
                for (i = 0; i < this.magnitudes.length; ++i) {
                    this.magnitudes[i] = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
                    this.orientations[i] = new FImage(((FImage)this.currentGradientProperties.image).width, ((FImage)this.currentGradientProperties.image).height);
                }
            }
            FImageGradients.gradientMagnitudesAndOrientations((FImage)((FImage)this.currentGradientProperties.image), (FImage)this.currentGradientProperties.magnitude, (FImage)this.currentGradientProperties.orientation);
            for (i = 0; i < this.magnitudes.length; ++i) {
                FImageGradients.gradientMagnitudesAndOrientations((FImage)((FImage)this.image.getBand(i + 1)), (FImage)this.magnitudes[i], (FImage)this.orientations[i]);
            }
        }
        this.currentGradientProperties.x = properties.x;
        this.currentGradientProperties.y = properties.y;
        this.currentGradientProperties.scale = properties.scale;
        return this.currentGradientProperties;
    }

    protected OrientedFeatureVector createFeature(float orientation) {
        float fx = this.currentGradientProperties.x;
        float fy = this.currentGradientProperties.y;
        float scale = this.currentGradientProperties.scale;
        GradientFeatureProvider[] sfe = new GradientFeatureProvider[this.magnitudes.length];
        for (int i = 0; i < this.magnitudes.length; ++i) {
            sfe[i] = this.factory.newProvider();
            sfe[i].setPatchOrientation(orientation);
        }
        int ix = Math.round(fx);
        int iy = Math.round(fy);
        float sin = (float)Math.sin(orientation);
        float cos = (float)Math.cos(orientation);
        float oversampling = sfe[0].getOversamplingAmount();
        float boundingBoxSize = this.magnification * scale;
        float extraSampling = oversampling * boundingBoxSize;
        float samplingBoxSize = extraSampling + boundingBoxSize + extraSampling;
        float orientedSamplingBoxSize = Math.abs(sin * samplingBoxSize) + Math.abs(cos * samplingBoxSize);
        int orientedSamplingBoxHalfSize = Math.round(orientedSamplingBoxSize / 2.0f);
        int width = this.magnitudes[0].width;
        int height = this.magnitudes[0].height;
        for (int y = -orientedSamplingBoxHalfSize; y <= orientedSamplingBoxHalfSize; ++y) {
            for (int x = -orientedSamplingBoxHalfSize; x <= orientedSamplingBoxHalfSize; ++x) {
                int px = x + ix;
                int py = y + iy;
                if (px < 0 || px >= width || py < 0 || py >= height) continue;
                float sx = 0.5f + (-sin * (float)y + cos * (float)x - (fx - (float)ix)) / boundingBoxSize;
                float sy = 0.5f + (cos * (float)y + sin * (float)x - (fy - (float)iy)) / boundingBoxSize;
                if (!(sx > -oversampling) || !(sx < 1.0f + oversampling) || !(sy > -oversampling) || !(sy < 1.0f + oversampling)) continue;
                for (int i = 0; i < this.magnitudes.length; ++i) {
                    sfe[i].addSample(sx, sy, this.magnitudes[i].pixels[py][px], this.orientations[i].pixels[py][px]);
                }
            }
        }
        OrientedFeatureVector first = sfe[0].getFeatureVector();
        OrientedFeatureVector fv = new OrientedFeatureVector(sfe.length * first.length(), orientation);
        System.arraycopy(first.values, 0, fv.values, 0, ((byte[])first.values).length);
        for (int i = 1; i < this.magnitudes.length; ++i) {
            System.arraycopy(sfe[i].getFeatureVector().values, 0, fv.values, i * ((byte[])first.values).length, ((byte[])first.values).length);
        }
        return fv;
    }
}

