/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.SparseIntFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.Location;
import org.openimaj.feature.local.quantised.QuantisedLocalFeature;
import org.openimaj.image.feature.local.aggregate.VectorAggregator;
import org.openimaj.ml.clustering.assignment.HardAssigner;

public class BagOfVisualWords<T>
implements VectorAggregator<ArrayFeatureVector<T>, SparseIntFV> {
    private HardAssigner<T, ?, ?> assigner;

    public BagOfVisualWords(HardAssigner<T, ?, ?> assigner) {
        this.assigner = assigner;
    }

    public static <L extends Location, T> List<QuantisedLocalFeature<L>> computeQuantisedFeatures(HardAssigner<T, ?, ?> assigner, List<? extends LocalFeature<L, ? extends ArrayFeatureVector<T>>> features) {
        ArrayList<QuantisedLocalFeature<L>> out = new ArrayList<QuantisedLocalFeature<L>>(features.size());
        for (LocalFeature<L, ArrayFeatureVector<T>> localFeature : features) {
            int idx = assigner.assign(((ArrayFeatureVector)localFeature.getFeatureVector()).values);
            out.add(new QuantisedLocalFeature(localFeature.getLocation(), idx));
        }
        return out;
    }

    public static <L extends Location> SparseIntFV extractFeatureFromQuantised(Collection<? extends QuantisedLocalFeature<L>> qfeatures, int nfeatures) {
        SparseIntFV fv = new SparseIntFV(nfeatures);
        for (QuantisedLocalFeature<L> qf : qfeatures) {
            fv.values.increment(qf.id, 1);
        }
        return fv;
    }

    @Override
    public SparseIntFV aggregate(List<? extends LocalFeature<?, ? extends ArrayFeatureVector<T>>> features) {
        SparseIntFV fv = new SparseIntFV(this.assigner.size());
        for (LocalFeature<?, ArrayFeatureVector<T>> localFeature : features) {
            int idx = this.assigner.assign(((ArrayFeatureVector)localFeature.getFeatureVector()).values);
            fv.values.increment(idx, 1);
        }
        return fv;
    }

    @Override
    public SparseIntFV aggregateVectors(List<? extends ArrayFeatureVector<T>> features) {
        SparseIntFV fv = new SparseIntFV(this.assigner.size());
        for (ArrayFeatureVector<T> f : features) {
            int idx = this.assigner.assign(f.values);
            fv.values.increment(idx, 1);
        }
        return fv;
    }

    public SparseIntFV aggregateVectorsRaw(List<T> features) {
        SparseIntFV fv = new SparseIntFV(this.assigner.size());
        for (T f : features) {
            int idx = this.assigner.assign(f);
            fv.values.increment(idx, 1);
        }
        return fv;
    }
}

