/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class MatchingUtilities {
    public static <T, I extends Image<T, I>> I drawMatches(I im1, I im2, List<? extends Pair<? extends Point2d>> matches, T col) {
        int newwidth = im1.getWidth() + im2.getWidth();
        int newheight = Math.max(im1.getHeight(), im2.getHeight());
        Image out = im1.newInstance(newwidth, newheight);
        ImageRenderer renderer = out.createRenderer();
        renderer.drawImage(im1, 0, 0);
        renderer.drawImage(im2, im1.getWidth(), 0);
        if (matches != null) {
            for (Pair<? extends Point2d> pair : matches) {
                renderer.drawLine((int)((Point2d)pair.firstObject()).getX() + im1.getWidth(), (int)((Point2d)pair.firstObject()).getY(), (int)((Point2d)pair.secondObject()).getX(), (int)((Point2d)pair.secondObject()).getY(), 1, col);
            }
        }
        return (I)out;
    }

    public static <T, I extends Image<T, I>> I drawMatches(I im1, I im2, List<? extends Pair<? extends Point2d>> matches, T col, List<? extends Pair<? extends Point2d>> matches2, T col2) {
        int newwidth = im1.getWidth() + im2.getWidth();
        int newheight = Math.max(im1.getHeight(), im2.getHeight());
        Image out = im1.newInstance(newwidth, newheight);
        ImageRenderer renderer = out.createRenderer();
        renderer.drawImage(im1, 0, 0);
        renderer.drawImage(im2, im1.getWidth(), 0);
        if (matches != null) {
            for (Pair<? extends Point2d> pair : matches) {
                renderer.drawLine((int)((Point2d)pair.firstObject()).getX() + im1.getWidth(), (int)((Point2d)pair.firstObject()).getY(), (int)((Point2d)pair.secondObject()).getX(), (int)((Point2d)pair.secondObject()).getY(), col);
            }
        }
        if (matches2 != null) {
            for (Pair<? extends Point2d> pair : matches2) {
                renderer.drawLine((int)((Point2d)pair.firstObject()).getX() + im1.getWidth(), (int)((Point2d)pair.firstObject()).getY(), (int)((Point2d)pair.secondObject()).getX(), (int)((Point2d)pair.secondObject()).getY(), col2);
            }
        }
        return (I)out;
    }

    public static <T, I extends Image<T, I>> I drawMatches(I image, List<IndependentPair<Point2d, Point2d>> matches, T col) {
        Image out = image.clone();
        ImageRenderer renderer = out.createRenderer();
        if (matches != null) {
            for (IndependentPair<Point2d, Point2d> p : matches) {
                renderer.drawLine((int)((Point2d)p.firstObject()).getX(), (int)((Point2d)p.firstObject()).getY(), (int)((Point2d)p.secondObject()).getX(), (int)((Point2d)p.secondObject()).getY(), col);
            }
        }
        return (I)out;
    }

    public static <T, I extends Image<T, I>> void displayMouseOverMatches(I im1, I im2, List<Pair<Keypoint>> matches, T col) {
        int newwidth = im1.getWidth() + im2.getWidth();
        int newheight = Math.max(im1.getHeight(), im2.getHeight());
        Image out = im1.newInstance(newwidth, newheight);
        ImageRenderer renderer = out.createRenderer();
        renderer.drawImage(im1, 0, 0);
        renderer.drawImage(im2, im1.getWidth(), 0);
        JFrame frame = DisplayUtilities.display((Image)out);
        MouseOverFeatureListener<T, I> mofl = new MouseOverFeatureListener<T, I>(im1, im2, frame, matches, col);
        frame.addKeyListener(mofl);
        frame.getContentPane().addMouseMotionListener(mofl);
    }

    static class MouseOverFeatureListener<T, I extends Image<T, I>>
    implements MouseMotionListener,
    KeyListener {
        private JFrame frame;
        private List<Pair<Keypoint>> matches;
        private T colour;
        private I im1;
        private I im2;
        private boolean allMode;

        public MouseOverFeatureListener(I im1, I im2, JFrame frame, List<Pair<Keypoint>> matches, T colour) {
            this.im1 = im1;
            this.im2 = im2;
            this.frame = frame;
            this.matches = matches;
            this.colour = colour;
            this.allMode = false;
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
            List<Pair<Keypoint>> toDisplay = null;
            if (this.allMode) {
                toDisplay = this.matches;
            } else {
                Point2dImpl mousePoint = new Point2dImpl((float)(arg0.getX() - this.im1.getWidth()), (float)arg0.getY());
                toDisplay = new ArrayList<Pair<Keypoint>>();
                for (Pair<Keypoint> kpair : this.matches) {
                    Keypoint toCompare = (Keypoint)kpair.firstObject();
                    if (!(Line2d.distance((Point2d)mousePoint, (Point2d)toCompare) < 10.0)) continue;
                    toDisplay.add(kpair);
                }
            }
            I image = MatchingUtilities.drawMatches(this.im1, this.im2, toDisplay, this.colour);
            DisplayUtilities.display(image, (JFrame)this.frame);
        }

        @Override
        public void keyPressed(KeyEvent key) {
            this.keyTyped(key);
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent key) {
            if (key.getKeyCode() == 32) {
                this.allMode = !this.allMode;
            }
        }
    }
}

