/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.knn.approximate.ByteNearestNeighboursKDTree;
import org.openimaj.util.pair.Pair;

public class FastEuclideanKeypointMatcher<T extends Keypoint>
implements LocalFeatureMatcher<T> {
    private ByteNearestNeighboursKDTree modelKeypointsKNN;
    private int threshold;
    protected List<Pair<T>> matches;
    private List<T> modelKeypoints;

    public FastEuclideanKeypointMatcher(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void setModelFeatures(List<T> modelkeys) {
        this.modelKeypoints = modelkeys;
        byte[][] data = new byte[modelkeys.size()][];
        for (int i = 0; i < modelkeys.size(); ++i) {
            data[i] = ((Keypoint)modelkeys.get((int)i)).ivec;
        }
        this.modelKeypointsKNN = new ByteNearestNeighboursKDTree((byte[][])data, 8, 768);
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        this.matches = new ArrayList<Pair<T>>();
        byte[][] data = new byte[keys1.size()][];
        for (int i = 0; i < keys1.size(); ++i) {
            data[i] = ((Keypoint)keys1.get((int)i)).ivec;
        }
        int[] argmins = new int[keys1.size()];
        float[] mins = new float[keys1.size()];
        this.modelKeypointsKNN.searchNN((byte[][])data, argmins, mins);
        for (int i = 0; i < keys1.size(); ++i) {
            float distsq = mins[i];
            if (!(distsq < (float)this.threshold)) continue;
            this.matches.add(new Pair(keys1.get(i), this.modelKeypoints.get(argmins[i])));
        }
        return true;
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.matches;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

