/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.util.pair.Pair;

@References(references={@Reference(type=ReferenceType.Article, author={"David Lowe"}, title="Distinctive image features from scale-invariant keypoints", year="2004", journal="IJCV", pages={"91", "110"}, month="January", number="2", volume="60"), @Reference(type=ReferenceType.Inproceedings, author={"David Lowe"}, title="Object recognition from local scale-invariant features", year="1999", booktitle="Proc. of the International Conference on Computer Vision {ICCV}", pages={"1150", "1157"})})
public class BasicMatcher<T extends LocalFeature<?, ?>>
implements LocalFeatureMatcher<T> {
    protected List<T> modelKeypoints;
    protected List<Pair<T>> matches = new ArrayList<Pair<T>>();
    protected int thresh = 8;

    public BasicMatcher(int threshold) {
        this.thresh = threshold;
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.matches;
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        this.matches = new ArrayList<Pair<T>>();
        for (LocalFeature k : keys1) {
            LocalFeature match = this.checkForMatch(k, this.modelKeypoints);
            if (match == null) continue;
            this.matches.add(new Pair((Object)k, (Object)match));
        }
        return true;
    }

    protected T checkForMatch(T query, List<T> features) {
        double distsq1 = Double.MAX_VALUE;
        double distsq2 = Double.MAX_VALUE;
        LocalFeature minkey = null;
        for (LocalFeature target : features) {
            double dsq = target.getFeatureVector().asDoubleFV().compare(query.getFeatureVector().asDoubleFV(), DoubleFVComparison.SUM_SQUARE);
            if (dsq < distsq1) {
                distsq2 = distsq1;
                distsq1 = dsq;
                minkey = target;
                continue;
            }
            if (!(dsq < distsq2)) continue;
            distsq2 = dsq;
        }
        if (100.0 * distsq1 < (double)(this.thresh * this.thresh) * distsq2) {
            return (T)minkey;
        }
        return null;
    }

    @Override
    public void setModelFeatures(List<T> modelkeys) {
        this.modelKeypoints = modelkeys;
    }

    public void setThreshold(int thresh) {
        this.thresh = thresh;
    }
}

