/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticdesktop.aperture.util.SimpleSAXListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSAXParser {
    private SAXParser saxParser;
    private SimpleSAXListener listener;
    private boolean trimWhitespace = true;

    public SimpleSAXParser(SAXParser saxParser) {
        this.saxParser = saxParser;
    }

    public SimpleSAXParser() throws ParserConfigurationException, SAXException {
        this(SAXParserFactory.newInstance().newSAXParser());
    }

    public void setListener(SimpleSAXListener listener) {
        this.listener = listener;
    }

    public SimpleSAXListener getListener() {
        return this.listener;
    }

    public void setTrimWhiteSpace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public synchronized void parse(InputStream in) throws SAXException, IOException {
        this.saxParser.parse(in, (DefaultHandler)new SimpleSAXDefaultHandler());
    }

    public synchronized void parse(InputStream in, String systemId) throws SAXException, IOException {
        this.saxParser.parse(in, new SimpleSAXDefaultHandler(), systemId);
    }

    public synchronized void parse(File file) throws SAXException, IOException {
        this.saxParser.parse(file, (DefaultHandler)new SimpleSAXDefaultHandler());
    }

    private class SimpleSAXDefaultHandler
    extends DefaultHandler {
        private StringBuilder charBuf = new StringBuilder(512);
        private String deferredStartTag = null;
        private Map deferredAttributes = null;

        public void startDocument() throws SAXException {
            SimpleSAXParser.this.listener.startDocument();
        }

        public void endDocument() throws SAXException {
            SimpleSAXParser.this.listener.endDocument();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuf.append(ch, start, length);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.deferredStartTag != null) {
                this.reportDeferredStartElement();
            }
            this.deferredStartTag = qName;
            int attCount = attributes.getLength();
            if (attCount == 0) {
                this.deferredAttributes = Collections.EMPTY_MAP;
            } else {
                this.deferredAttributes = new HashMap(attCount * 2);
                for (int i = 0; i < attCount; ++i) {
                    this.deferredAttributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            this.charBuf.setLength(0);
        }

        private void reportDeferredStartElement() throws SAXException {
            SimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, "");
            this.deferredStartTag = null;
            this.deferredAttributes = null;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.deferredStartTag != null) {
                String text = this.charBuf.toString();
                if (SimpleSAXParser.this.trimWhitespace) {
                    text = text.trim();
                }
                SimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, text);
                this.deferredStartTag = null;
                this.deferredAttributes = null;
            }
            SimpleSAXParser.this.listener.endTag(qName);
            this.charBuf.setLength(0);
        }
    }
}

