/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmd.CmdException;
import com.hp.hpl.jena.sparql.util.Utils;
import java.sql.Connection;
import java.util.List;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;
import sdb.cmd.CmdArgsDB;
import sdb.junit.TextListener2;
import sdb.test.Env;
import sdb.test.Params;
import sdb.test.TestI18N;
import sdb.test.TestStringBasic;

public class DBTest
extends CmdArgsDB {
    String filename = null;
    Params params = new Params();

    public static void main(String[] argv) {
        new DBTest(argv).mainAndExit();
    }

    public DBTest(String[] args) {
        super(args);
        this.params.put("TempTable", "FOO");
        this.params.put("typeBinary", "BLOB");
        this.params.put("colBinary", "colBinary");
        this.params.put("typeVarchar", "VARCHAR(200)");
        this.params.put("colVarchar", "colVarchar");
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " <SPEC> ";
    }

    protected void processModulesAndArgs() {
        List args = this.getPositional();
        this.setParams(args);
    }

    @Override
    protected void execCmd(List<String> args) {
        if (this.isVerbose()) {
            for (String k : this.params) {
                System.out.printf("%-20s = %-20s\n", k, this.params.get(k));
            }
            System.out.println();
        }
        Connection jdbc = this.getModStore().getConnection().getSqlConnection();
        Env.set(jdbc, this.params, false);
        JUnitCore x = new JUnitCore();
        TextListener2 listener = new TextListener2(System.out);
        x.addListener((RunListener)listener);
        System.out.println("String basic");
        x.run(new Class[]{TestStringBasic.class});
        System.out.println("String I18N");
        x.run(new Class[]{TestI18N.class});
    }

    private void setParams(List<String> args) {
        for (String s : args) {
            String[] frags = s.split("=", 2);
            if (frags.length != 2) {
                throw new CmdException("Can't split '" + s + "'");
            }
            this.params.put(frags[0], frags[1]);
        }
    }
}

