/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.sql.RS;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.store.SQLBridge;
import com.hp.hpl.jena.sdb.store.TableDesc;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.util.Context;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openjena.atlas.iterator.Iter;

public class TupleTable {
    private TableDesc desc;
    private Store store;
    private List<Var> vars;
    private SqlTable sqlTable;

    public TupleTable(Store store, String tableName) {
        this(store, TupleTable.getDesc(store, tableName));
    }

    public TupleTable(Store store, TableDesc desc) {
        this.store = store;
        this.desc = desc;
        this.sqlTable = new SqlTable(desc.getTableName(), desc.getTableName());
        this.vars = new ArrayList<Var>();
        for (String colName : Iter.iter(desc.colNames())) {
            Var var = Var.alloc((String)colName);
            this.vars.add(var);
            this.sqlTable.setIdColumnForVar(var, new SqlColumn(this.sqlTable, colName));
        }
    }

    private static TableDesc getDesc(Store store, String tableName) {
        TableDesc tableDesc;
        ResultSetJDBC tableData = null;
        ArrayList<String> colVars = new ArrayList<String>();
        try {
            tableData = store.getConnection().execQuery("SELECT * FROM " + tableName);
            ResultSetMetaData meta = tableData.get().getMetaData();
            int N = meta.getColumnCount();
            for (int i = 1; i <= N; ++i) {
                String colName = meta.getColumnName(i);
                colVars.add(colName);
            }
            tableDesc = new TableDesc(tableName, colVars);
        }
        catch (SQLException ex) {
            try {
                throw new SDBExceptionSQL(ex);
            }
            catch (Throwable throwable) {
                RS.close(tableData);
                throw throwable;
            }
        }
        RS.close(tableData);
        return tableDesc;
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public QueryIterator iterator() {
        SDBRequest request = new SDBRequest(this.store, null);
        String tableName = this.desc.getTableName();
        SQLBridge b = this.store.getSQLBridgeFactory().create(request, this.sqlTable, this.vars);
        b.build();
        try {
            String sqlStr = this.store.getSQLGenerator().generateSQL(request, b.getSqlNode());
            ResultSetJDBC tableData = this.store.getConnection().execQuery(sqlStr);
            ExecutionContext execCxt = new ExecutionContext(new Context(), null, null, null);
            return b.assembleResults(tableData, BindingRoot.create(), execCxt);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public void dump() {
        QueryIterator qIter = this.iterator();
        ResultSetFormatter.out((ResultSet)ResultSetFactory.create((QueryIterator)qIter, (List)Var.varNames(this.vars)));
    }
}

