/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.compiler.QuadBlock;
import com.hp.hpl.jena.sdb.compiler.SqlBuilder;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Equal;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlConstant;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.layout2.NodeLayout2;
import com.hp.hpl.jena.sdb.layout2.SlotCompiler2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotCompilerIndex
extends SlotCompiler2 {
    private static Logger log = LoggerFactory.getLogger(SlotCompilerIndex.class);
    private static final String NodeConstBase = "N";
    Map<Node, SqlColumn> constantCols = new HashMap<Node, SqlColumn>();
    private List<Node> constants;
    private List<Var> vars;
    protected TableDescTriples tripleTableDesc;
    protected TableDescNodes nodeTableDesc;
    private SqlNode constantsSqlNode;

    public SlotCompilerIndex(SDBRequest request) {
        super(request);
        this.tripleTableDesc = request.getStore().getTripleTableDesc();
        this.nodeTableDesc = request.getStore().getNodeTableDesc();
    }

    @Override
    public SqlNode start(QuadBlock quads) {
        this.constants = new ArrayList<Node>();
        this.vars = new ArrayList<Var>();
        this.classify(quads, this.constants, this.vars);
        this.constantsSqlNode = this.insertConstantAccesses(this.constants);
        return this.constantsSqlNode;
    }

    @Override
    protected void constantSlot(SDBRequest request, Node node, SqlColumn thisCol, SqlExprList conditions) {
        SqlColumn colId = this.constantCols.get(node);
        if (colId == null) {
            log.warn("Failed to find id col for " + node);
            return;
        }
        S_Equal c = new S_Equal(thisCol, colId);
        c.addNote("Const condition: " + FmtUtils.stringForNode((Node)node, (PrefixMapping)this.getRequest().getPrefixMapping()));
        conditions.add(c);
    }

    protected SqlNode insertConstantAccesses(Collection<Node> constants) {
        SqlNode sqlNode = null;
        for (Node n : constants) {
            long hash = NodeLayout2.hash(n);
            SqlConstant hashValue = new SqlConstant(hash);
            SqlTable nTable = new SqlTable(this.getRequest().genId(NodeConstBase), this.nodeTableDesc.getTableName());
            nTable.addNote("Const: " + FmtUtils.stringForNode((Node)n, (PrefixMapping)this.getRequest().getPrefixMapping()));
            SqlColumn cHash = new SqlColumn(nTable, this.nodeTableDesc.getHashColName());
            this.constantCols.put(n, new SqlColumn(nTable, this.nodeTableDesc.getIdColName()));
            S_Equal c = new S_Equal(cHash, hashValue);
            sqlNode = SqlBuilder.innerJoin(this.getRequest(), sqlNode, nTable);
            sqlNode = SqlBuilder.restrict(this.getRequest(), sqlNode, c);
        }
        return sqlNode;
    }

    protected void classify(QuadBlock quadBlock, Collection<Node> constants, Collection<Var> vars) {
        for (Quad quad : quadBlock) {
            if (!Quad.isDefaultGraph((Node)quad.getGraph()) && !quad.isUnionGraph()) {
                SlotCompilerIndex.acc(constants, vars, quad.getGraph());
            }
            SlotCompilerIndex.acc(constants, vars, quad.getSubject());
            SlotCompilerIndex.acc(constants, vars, quad.getPredicate());
            SlotCompilerIndex.acc(constants, vars, quad.getObject());
        }
    }

    private static void acc(Collection<Node> constants, Collection<Var> vars, Node node) {
        if (node.isLiteral() || node.isBlank() || node.isURI()) {
            if (!constants.contains(node)) {
                constants.add(node);
            }
            return;
        }
        if (Var.isVar((Node)node)) {
            vars.add(Var.alloc((Node)node));
            return;
        }
        if (node.isVariable()) {
            log.warn("Node_Varable but not a Var; bodged");
            vars.add(Var.alloc((Node)node));
            return;
        }
        log.error("Unknown Node type: " + node);
        throw new SDBException("Unknown Node type: " + node);
    }
}

