/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.Annotation1;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.ScopeRename;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoin;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase1;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTransform;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashSet;
import java.util.Set;
import org.openjena.atlas.lib.SetUtils;
import org.slf4j.LoggerFactory;

public class SqlCoalesce
extends SqlNodeBase1 {
    private SqlJoin join;
    private Set<Var> coalesceVars;
    private Set<Var> nonCoalesceVars = new HashSet<Var>();
    private ScopeRename idScope;
    private ScopeRename nodeScope;
    private static final String AliasBase = "VC";

    public static SqlCoalesce create(SDBRequest request, String alias, SqlJoin join, Set<Var> coalesceVars) {
        if (!join.isLeftJoin()) {
            LoggerFactory.getLogger(SqlCoalesce.class).warn("SqlCoalesce node is not a LeftJoin");
        }
        return new SqlCoalesce(request, alias, join, coalesceVars);
    }

    private SqlCoalesce(String alias, SqlJoin join, Set<Var> coalesceVars) {
        super(alias, join);
        this.join = join;
        this.coalesceVars = coalesceVars;
    }

    private SqlCoalesce(SDBRequest request, String alias, SqlJoin join, Set<Var> coalesceVars) {
        this(alias, join, coalesceVars);
        SqlColumn col;
        String sqlColName;
        Annotation1 annotation = new Annotation1(true);
        this.idScope = new ScopeRename(join.getIdScope());
        this.nodeScope = new ScopeRename(join.getNodeScope());
        SqlTable table = new SqlTable(alias);
        this.nonCoalesceVars = SetUtils.difference(join.getIdScope().getVars(), coalesceVars);
        for (Var v : coalesceVars) {
            sqlColName = request.genId(AliasBase);
            col = new SqlColumn(table, sqlColName);
            this.idScope.setAlias(v, col);
            annotation.addAnnotation(v + " as " + col);
        }
        for (Var v : this.nonCoalesceVars) {
            if (coalesceVars.contains(v)) {
                LoggerFactory.getLogger(SqlCoalesce.class).warn("Variable in coalesce and non-coalesce sets: " + v);
                continue;
            }
            sqlColName = request.genId(AliasBase);
            col = new SqlColumn(table, sqlColName);
            this.idScope.setAlias(v, col);
            annotation.addAnnotation(v + " as " + col);
        }
        annotation.setAnnotation(this);
    }

    public Set<Var> getCoalesceVars() {
        return this.coalesceVars;
    }

    public Set<Var> getNonCoalesceVars() {
        return this.nonCoalesceVars;
    }

    @Override
    public boolean isCoalesce() {
        return true;
    }

    @Override
    public SqlCoalesce asCoalesce() {
        return this;
    }

    @Override
    public Scope getIdScope() {
        return this.idScope;
    }

    @Override
    public Scope getNodeScope() {
        return this.nodeScope;
    }

    public SqlJoin getJoinNode() {
        return this.join;
    }

    @Override
    public void visit(SqlNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SqlNode apply(SqlTransform transform, SqlNode newSubNode) {
        return transform.transform(this, newSubNode);
    }

    @Override
    public SqlNode copy(SqlNode subNode) {
        SqlCoalesce s = new SqlCoalesce(this.getAliasName(), subNode.asJoin(), this.coalesceVars);
        s.nonCoalesceVars = this.nonCoalesceVars;
        s.idScope = this.idScope;
        s.nodeScope = this.nodeScope;
        return s;
    }
}

