/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core;

import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.ScopeStatus;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Set;
import org.openjena.atlas.iterator.Iter;

public class ScopeOptional
implements Scope {
    private Scope scope;
    private ScopeStatus scopeStatus = ScopeStatus.OPTIONAL;

    public ScopeOptional(Scope subScope) {
        this.scope = subScope;
    }

    @Override
    public ScopeEntry findScopeForVar(Var var) {
        ScopeEntry e = this.scope.findScopeForVar(var);
        if (e == null) {
            return null;
        }
        e = e.duplicate();
        e.setStatus(this.scopeStatus);
        return e;
    }

    @Override
    public Set<Var> getVars() {
        return this.scope.getVars();
    }

    @Override
    public boolean isEmpty() {
        return this.scope.isEmpty();
    }

    @Override
    public Set<ScopeEntry> findScopes() {
        Set<ScopeEntry> x = this.scope.findScopes();
        Iter.apply(x, ScopeEntry.SetOpt);
        return x;
    }

    @Override
    public boolean hasColumnForVar(Var var) {
        return this.scope.hasColumnForVar(var);
    }

    public String toString() {
        return "Opt(" + this.scope.toString() + ")";
    }
}

