/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.compiler.SlotCompiler;
import com.hp.hpl.jena.sdb.compiler.SqlBuilder;
import com.hp.hpl.jena.sdb.compiler.SqlStage;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import org.openjena.atlas.io.IndentedWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlStageBasicQuad
implements SqlStage {
    private static Logger log = LoggerFactory.getLogger(SqlStageBasicQuad.class);
    private Quad quad;

    public SqlStageBasicQuad(Quad quad) {
        this.quad = quad;
    }

    @Override
    public SqlNode build(SDBRequest request, SlotCompiler slotCompiler) {
        SqlExprList conditions = new SqlExprList();
        boolean defaultGraph = Quad.isDefaultGraph((Node)this.quad.getGraph());
        boolean unionGraph = this.quad.isUnionGraph();
        boolean accessStoredDefaultGraph = Quad.isDefaultGraph((Node)this.quad.getGraph());
        boolean accessUnionGraph = false;
        if (accessStoredDefaultGraph && request.getContext().isTrue(SDB.unionDefaultGraph)) {
            defaultGraph = false;
            unionGraph = true;
            accessStoredDefaultGraph = false;
            accessUnionGraph = true;
        }
        if (this.quad.isDefaultGraphExplicit()) {
            accessStoredDefaultGraph = true;
            accessUnionGraph = false;
        }
        if (this.quad.isUnionGraph()) {
            accessStoredDefaultGraph = false;
            accessUnionGraph = true;
        }
        TableDescQuads tableDesc = null;
        String alias = null;
        if (accessStoredDefaultGraph) {
            tableDesc = request.getStore().getTripleTableDesc();
            alias = request.genId("T");
        } else {
            tableDesc = request.getStore().getQuadTableDesc();
            alias = request.genId("Q");
        }
        SqlTable table = new SqlTable(alias, tableDesc.getTableName());
        if (accessStoredDefaultGraph) {
            table.addNote(FmtUtils.stringForTriple((Triple)this.quad.asTriple(), (PrefixMapping)request.getPrefixMapping()));
        } else {
            table.addNote(FmtUtils.stringForQuad((Quad)this.quad, (PrefixMapping)request.getPrefixMapping()));
        }
        if (!accessStoredDefaultGraph && !accessUnionGraph) {
            slotCompiler.processSlot(request, table, conditions, this.quad.getGraph(), tableDesc.getGraphColName());
        }
        slotCompiler.processSlot(request, table, conditions, this.quad.getSubject(), tableDesc.getSubjectColName());
        slotCompiler.processSlot(request, table, conditions, this.quad.getPredicate(), tableDesc.getPredicateColName());
        slotCompiler.processSlot(request, table, conditions, this.quad.getObject(), tableDesc.getObjectColName());
        return SqlBuilder.restrict(request, (SqlNode)table, conditions);
    }

    public String toString() {
        return "Table: " + this.quad;
    }

    public void output(IndentedWriter out) {
        out.print((Object)this.toString());
    }
}

