/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.restoration.inpainting;

import java.util.Collection;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.processing.restoration.inpainting.Inpainter;

public abstract class AbstractImageMaskInpainter<IMAGE extends Image<?, IMAGE>>
implements Inpainter<IMAGE> {
    protected FImage mask;

    @Override
    public void setMask(FImage mask) {
        this.mask = mask;
        this.initMask();
    }

    @Override
    public void setMask(int width, int height, Collection<? extends Iterable<Pixel>> mask) {
        this.mask = new FImage(width, height);
        for (Iterable<Pixel> iterable : mask) {
            for (Pixel p : iterable) {
                if (p.x < 0 || p.x >= width || p.y < 0 || p.y >= height) continue;
                this.mask.pixels[p.y][p.x] = 1.0f;
            }
        }
        this.initMask();
    }

    @Override
    public void setMask(int width, int height, PixelSet ... mask) {
        this.mask = new FImage(width, height);
        for (PixelSet ps : mask) {
            for (Pixel p : ps) {
                if (p.x < 0 || p.x >= width || p.y < 0 || p.y >= height) continue;
                this.mask.pixels[p.y][p.x] = 1.0f;
            }
        }
        this.initMask();
    }

    protected void initMask() {
    }

    @Override
    public final void processImage(IMAGE image) {
        if (this.mask == null) {
            throw new IllegalArgumentException("Mask has not been set");
        }
        if (image.getWidth() != this.mask.getWidth() || image.getHeight() != this.mask.getHeight()) {
            throw new IllegalArgumentException("Image and mask size do not match");
        }
        this.performInpainting(image);
    }

    protected abstract void performInpainting(IMAGE var1);
}

