/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.morphology;

import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processing.morphology.HitAndMiss;
import org.openimaj.image.processing.morphology.StructuringElement;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;

public class SequentialThin
implements ConnectedComponentProcessor,
ImageProcessor<FImage> {
    protected HitAndMiss hitAndMiss;
    protected int niter = -1;

    public SequentialThin(StructuringElement ... se) {
        this.hitAndMiss = new HitAndMiss(se);
    }

    public SequentialThin(int niter, StructuringElement ... se) {
        this.hitAndMiss = new HitAndMiss(se);
        this.niter = niter;
    }

    public void process(ConnectedComponent cc) {
        for (int i = this.niter; i != 0; --i) {
            this.hitAndMiss.process(cc);
            if (this.hitAndMiss.outputPixels.size() == 0) break;
            cc.getPixels().removeAll(this.hitAndMiss.outputPixels);
        }
    }

    public void processImage(FImage image) {
        for (int i = this.niter; i != 0; --i) {
            FImage newImage = image.process((KernelProcessor)this.hitAndMiss, true);
            int count = 0;
            for (int y = 0; y < newImage.height; ++y) {
                for (int x = 0; x < newImage.width; ++x) {
                    if (newImage.pixels[y][x] != 1.0f) continue;
                    ++count;
                    image.pixels[y][x] = 0.0f;
                }
            }
            if (count == 0) break;
        }
    }
}

