/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processing.convolution.filterbank.FilterBank;

@Reference(type=ReferenceType.Inproceedings, author={"Laws, K. I."}, title="{Rapid Texture Identification}", year="1980", booktitle="Proc. SPIE Conf. Image Processing for Missile Guidance", pages={"376", "", "380"}, customData={"citeulike-article-id", "2335645", "keywords", "bibtex-import", "posted-at", "2008-02-05 15:32:50", "priority", "2"})
public class LawsTextureBase
extends FilterBank {
    private static final float[] L5 = new float[]{1.0f, 4.0f, 6.0f, 4.0f, 1.0f};
    private static final float[] E5 = new float[]{-1.0f, -2.0f, 0.0f, 2.0f, 1.0f};
    private static final float[] S5 = new float[]{-1.0f, 0.0f, 2.0f, 0.0f, -1.0f};
    private static final float[] R5 = new float[]{1.0f, -4.0f, 6.0f, -4.0f, 1.0f};
    protected static final int L5E5 = 0;
    protected static final int E5L5 = 1;
    protected static final int L5R5 = 2;
    protected static final int R5L5 = 3;
    protected static final int E5S5 = 4;
    protected static final int S5E5 = 5;
    protected static final int S5S5 = 6;
    protected static final int R5R5 = 7;
    protected static final int L5S5 = 8;
    protected static final int S5L5 = 9;
    protected static final int E5E5 = 10;
    protected static final int E5R5 = 11;
    protected static final int R5E5 = 12;
    protected static final int S5R5 = 13;
    protected static final int R5S5 = 14;

    public LawsTextureBase() {
        super(LawsTextureBase.makeFilters());
    }

    private static FConvolution[] makeFilters() {
        FConvolution[] filters = new FConvolution[]{LawsTextureBase.makeFilter(L5, E5), LawsTextureBase.makeFilter(E5, L5), LawsTextureBase.makeFilter(L5, R5), LawsTextureBase.makeFilter(R5, L5), LawsTextureBase.makeFilter(E5, S5), LawsTextureBase.makeFilter(S5, E5), LawsTextureBase.makeFilter(S5, S5), LawsTextureBase.makeFilter(R5, R5), LawsTextureBase.makeFilter(L5, S5), LawsTextureBase.makeFilter(S5, L5), LawsTextureBase.makeFilter(E5, E5), LawsTextureBase.makeFilter(E5, R5), LawsTextureBase.makeFilter(R5, E5), LawsTextureBase.makeFilter(S5, R5), LawsTextureBase.makeFilter(R5, S5)};
        return filters;
    }

    private static FConvolution makeFilter(float[] l, float[] r) {
        float[][] f = new float[l.length][r.length];
        for (int i = 0; i < l.length; ++i) {
            for (int j = 0; j < r.length; ++j) {
                f[i][j] = l[i] * r[j];
            }
        }
        return new FConvolution(f);
    }
}

