/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.ImageProcessor;

public class MeanCenter
implements ImageProcessor<FImage> {
    public void processImage(FImage image) {
        int width = image.width;
        int height = image.height;
        float[][] data = image.pixels;
        image.subtractInplace(Float.valueOf(MeanCenter.patchMean(data, 0, 0, width, height)));
    }

    public static final float patchMean(float[][] data) {
        return MeanCenter.patchMean(data, 0, 0, data.length > 0 && data[0] != null ? data[0].length : 0, data.length);
    }

    public static final float patchMean(float[][] data, int x, int y, int width, int height) {
        float accum = 0.0f;
        int endX = width + x;
        int endY = height + y;
        for (int yy = y; yy < endY; ++yy) {
            for (int xx = x; xx < endX; ++xx) {
                accum += data[yy][xx];
            }
        }
        float mean = accum / (float)(width * height);
        return mean;
    }
}

