/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import java.util.Set;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class LocalContrastFilter
implements SinglebandImageProcessor<Float, FImage> {
    private Set<Pixel> support;

    public LocalContrastFilter(Set<Pixel> support) {
        this.support = support;
    }

    public void processImage(FImage image) {
        FImage tmpImage = new FImage(image.width, image.height);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                float min = Float.MAX_VALUE;
                float max = -3.4028235E38f;
                for (Pixel sp : this.support) {
                    int xx = x + sp.x;
                    int yy = y + sp.y;
                    if (xx < 0 || xx >= image.width - 1 || yy < 0 || yy >= image.height - 1) continue;
                    min = Math.min(min, image.pixels[yy][xx]);
                    max = Math.max(max, image.pixels[yy][xx]);
                }
                tmpImage.pixels[y][x] = max - min;
            }
        }
        image.internalAssign(tmpImage);
    }
}

