/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import net.jafama.FastMath;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.SinglebandImageProcessor;

@Reference(type=ReferenceType.Article, author={"Perona, P.", "Malik, J."}, title="Scale-Space and Edge Detection Using Anisotropic Diffusion", year="1990", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"629", "", "639"}, url="http://dx.doi.org/10.1109/34.56205", month="July", number="7", publisher="IEEE Computer Society", volume="12", customData={"issue_date", "July 1990", "issn", "0162-8828", "numpages", "11", "doi", "10.1109/34.56205", "acmid", "78304", "address", "Washington, DC, USA"})
public class AnisotropicDiffusion
implements SinglebandImageProcessor<Float, FImage> {
    protected int numIterations;
    protected float lambda = 0.14285715f;
    protected ConductionCoefficientFunction function;
    protected ConnectedComponent.ConnectMode neighbourMode;

    public AnisotropicDiffusion(int numIterations, float lambda, ConductionCoefficientFunction function, ConnectedComponent.ConnectMode neighbourMode) {
        this.numIterations = numIterations;
        this.lambda = lambda;
        this.function = function;
        this.neighbourMode = neighbourMode;
    }

    public AnisotropicDiffusion(int numIterations, float lambda, ConductionCoefficientFunction function) {
        this.numIterations = numIterations;
        this.lambda = lambda;
        this.function = function;
        this.neighbourMode = ConnectedComponent.ConnectMode.CONNECT_4;
    }

    public void processImage(FImage image) {
        for (int i = 0; i < this.numIterations; ++i) {
            this.processImageOneIteration(image);
        }
    }

    public void processImageOneIteration(FImage image) {
        switch (this.neighbourMode) {
            case CONNECT_4: {
                this.processImageOneIteration4(image);
            }
            case CONNECT_8: {
                this.processImageOneIteration8(image);
            }
        }
    }

    private void processImageOneIteration4(FImage image) {
        float[][] tmp = image.clone().pixels;
        for (int y = 0; y < image.height; ++y) {
            int ym = Math.max(y - 1, 0);
            int yp = Math.min(y + 1, image.height - 1);
            int x = 0;
            while (x < image.width) {
                int xm = Math.max(x - 1, 0);
                int xp = Math.min(x + 1, image.width - 1);
                float dN = tmp[ym][x] - tmp[y][x];
                float dS = tmp[yp][x] - tmp[y][x];
                float dE = tmp[y][xm] - tmp[y][x];
                float dW = tmp[y][xp] - tmp[y][x];
                float cN = this.function.apply(Math.abs(dN), x, y);
                float cS = this.function.apply(Math.abs(dS), x, y);
                float cE = this.function.apply(Math.abs(dE), x, y);
                float cW = this.function.apply(Math.abs(dW), x, y);
                float[] fArray = image.pixels[y];
                int n = x++;
                fArray[n] = fArray[n] + this.lambda * (cN * dN + cS * dS + cE * dE + cW * dW);
            }
        }
    }

    private void processImageOneIteration8(FImage image) {
        float[][] tmp = image.clone().pixels;
        float wt = 0.5f;
        for (int y = 0; y < image.height; ++y) {
            int ym = Math.max(y - 1, 0);
            int yp = Math.min(y + 1, image.height - 1);
            int x = 0;
            while (x < image.width) {
                int xm = Math.max(x - 1, 0);
                int xp = Math.min(x + 1, image.width - 1);
                float dN = tmp[ym][x] - tmp[y][x];
                float dS = tmp[yp][x] - tmp[y][x];
                float dE = tmp[y][xm] - tmp[y][x];
                float dW = tmp[y][xp] - tmp[y][x];
                float dNE = tmp[ym][xm] - tmp[y][x];
                float dSE = tmp[yp][xm] - tmp[y][x];
                float dSW = tmp[ym][xp] - tmp[y][x];
                float dNW = tmp[ym][xp] - tmp[y][x];
                float cN = this.function.apply(Math.abs(dN), x, y);
                float cS = this.function.apply(Math.abs(dS), x, y);
                float cE = this.function.apply(Math.abs(dE), x, y);
                float cW = this.function.apply(Math.abs(dW), x, y);
                float cNE = this.function.apply(Math.abs(dNE), x, y);
                float cSE = this.function.apply(Math.abs(dSE), x, y);
                float cSW = this.function.apply(Math.abs(dSW), x, y);
                float cNW = this.function.apply(Math.abs(dNW), x, y);
                float[] fArray = image.pixels[y];
                int n = x++;
                fArray[n] = fArray[n] + this.lambda * (cN * dN + cS * dS + cE * dE + cW * dW + 0.5f * (cNE * dNE + cSE * dSE + cSW * dSW + cNW * dNW));
            }
        }
    }

    public static class WideRegionFunction
    implements ConductionCoefficientFunction {
        private float kappa;

        public WideRegionFunction(float kappa) {
            this.kappa = kappa;
        }

        @Override
        public float apply(float val, int x, int y) {
            float t = val / this.kappa;
            return 1.0f / (1.0f + t * t);
        }
    }

    public static class HighConstrastEdgeFunction
    implements ConductionCoefficientFunction {
        private float kappa;

        public HighConstrastEdgeFunction(float kappa) {
            this.kappa = kappa;
        }

        @Override
        public float apply(float val, int x, int y) {
            float t = val / this.kappa;
            return (float)FastMath.exp((double)(-t * t));
        }
    }

    public static interface ConductionCoefficientFunction {
        public float apply(float var1, int var2, int var3);
    }
}

