/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.watershed;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.watershed.WatershedProcessorAlgorithm;
import org.openimaj.image.analysis.watershed.event.ComponentStackMergeListener;
import org.openimaj.image.analysis.watershed.feature.ComponentFeature;
import org.openimaj.image.pixel.IntValuePixel;

public class WatershedProcessor {
    private IntValuePixel startPixel = new IntValuePixel(0, 0);
    private List<ComponentStackMergeListener> csmListeners = new ArrayList<ComponentStackMergeListener>();
    private Class<? extends ComponentFeature>[] featureClasses;

    @SafeVarargs
    public WatershedProcessor(Class<? extends ComponentFeature> ... featureClasses) {
        this.featureClasses = featureClasses;
    }

    public void processImage(FImage greyscaleImage) {
        WatershedProcessorAlgorithm d = new WatershedProcessorAlgorithm(greyscaleImage, this.startPixel, this.featureClasses);
        for (ComponentStackMergeListener csm : this.csmListeners) {
            d.addComponentStackMergeListener(csm);
        }
        d.startPour();
    }

    public void addComponentStackMergeListener(ComponentStackMergeListener csml) {
        this.csmListeners.add(csml);
    }
}

