/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.watershed;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openimaj.image.analysis.watershed.Component;
import org.openimaj.image.analysis.watershed.event.ComponentStackMergeListener;
import org.openimaj.util.tree.TreeNode;
import org.openimaj.util.tree.TreeNodeImpl;

public class MergeTreeBuilder
implements ComponentStackMergeListener {
    Logger logger = Logger.getLogger(MergeTreeBuilder.class);
    private TreeNode<Component> tree = null;
    private Map<Component, TreeNode<Component>> map = new HashMap<Component, TreeNode<Component>>();

    @Override
    public void componentsMerged(Component c1, Component c2) {
        this.logger.debug((Object)("Component c1: " + c1));
        this.logger.debug((Object)("Component c2: " + c2));
        TreeNodeImpl c1xtn = this.map.get(c1);
        if (c1xtn == null) {
            this.logger.debug((Object)"c1 not found");
            c1xtn = new TreeNodeImpl();
            Component c1x = c1.clone();
            c1xtn.setValue((Object)c1x);
            this.map.put(c1, (TreeNode<Component>)c1xtn);
        }
        ((Component)c1xtn.getValue()).merge(c2);
        TreeNodeImpl c2xtn = this.map.get(c2);
        if (c2xtn == null) {
            this.logger.debug((Object)"c2 not found");
            c2xtn = new TreeNodeImpl();
            Component c2x = c2.clone();
            c2xtn.setValue((Object)c2x);
            this.map.put(c2, (TreeNode<Component>)c2xtn);
        }
        c1xtn.addChild(c2xtn);
        this.tree = c1xtn;
    }

    @Override
    public void componentPromoted(Component c1) {
        TreeNode<Component> c1xtn_old = this.map.get(c1);
        Component c1x = c1.clone();
        TreeNodeImpl c1xtn = new TreeNodeImpl();
        c1xtn.setValue((Object)c1x);
        this.map.put(c1, (TreeNode<Component>)c1xtn);
        if (c1xtn_old != null) {
            c1xtn.addChild(c1xtn_old);
        }
    }

    public TreeNode<Component> getTree() {
        return this.tree;
    }
}

