/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

public class HorizontalProjection
implements ImageAnalyser<FImage> {
    float[] projection;

    public void analyseImage(FImage image) {
        this.projection = HorizontalProjection.project(image);
    }

    public static float[] project(FImage image) {
        float[] projection = new float[image.width];
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int n = x;
                projection[n] = projection[n] + image.pixels[y][x];
            }
        }
        return projection;
    }

    public float[] getProjection() {
        return this.projection;
    }
}

