/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.rdf.owl2java;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.rdf.serialize.RelationList;
import org.openimaj.rdf.serialize.TripleList;
import org.openimaj.util.pair.IndependentPair;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;

public abstract class Something {
    private String uri;
    private boolean allowUnvalidatedTriples = true;
    @TripleList
    private final List<Statement> unvalidatedTriples = new ArrayList<Statement>();
    private boolean allowUnvalidatedRelations = true;
    @RelationList
    private final List<IndependentPair<URI, Object>> unvalidatedRelations = new ArrayList<IndependentPair<URI, Object>>();

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void addUnvalidatedTuple(URI predicate, Value object) throws IllegalArgumentException {
        if (!this.allowUnvalidatedTriples) {
            throw new IllegalArgumentException("Adding tuples to a validated subgraph");
        }
        this.unvalidatedTriples.add((Statement)new StatementImpl((Resource)new URIImpl(this.uri), predicate, object));
    }

    public void setAllowUnvalidatedTriples(boolean tf) {
        this.allowUnvalidatedTriples = tf;
    }

    public void addUnvalidatedRelation(URI predicate, Object object) throws IllegalArgumentException {
        if (!this.allowUnvalidatedRelations) {
            throw new IllegalArgumentException("Adding relations to a validated subgraph");
        }
        this.unvalidatedRelations.add((IndependentPair<URI, Object>)new IndependentPair((Object)predicate, object));
    }

    public void setAllowUnvalidatedRelations(boolean tf) {
        this.allowUnvalidatedRelations = tf;
    }
}

