/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGenerator;
import opennlp.tools.util.featuregen.BigramNameFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.CharacterNgramFeatureGenerator;
import opennlp.tools.util.featuregen.DictionaryFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.PreviousMapFeatureGenerator;
import opennlp.tools.util.featuregen.SentenceFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import opennlp.tools.util.featuregen.TokenPatternFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeneratorFactory {
    private static Map<String, XmlFeatureGeneratorFactory> factories = new HashMap<String, XmlFeatureGeneratorFactory>();

    static AdaptiveFeatureGenerator createGenerator(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
        String elementName = generatorElement.getTagName();
        XmlFeatureGeneratorFactory generatorFactory = factories.get(elementName);
        if (generatorFactory == null) {
            throw new InvalidFormatException("Unexpected element: " + elementName);
        }
        return generatorFactory.create(generatorElement, resourceManager);
    }

    public static AdaptiveFeatureGenerator create(InputStream xmlDescriptorIn, FeatureGeneratorResourceProvider resourceManager) throws IOException, InvalidFormatException {
        Document xmlDescriptorDOM;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFacoty = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFacoty.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        try {
            xmlDescriptorDOM = documentBuilder.parse(xmlDescriptorIn);
        }
        catch (SAXException e) {
            throw new InvalidFormatException("Descriptor is not valid XML!", e);
        }
        Element generatorElement = xmlDescriptorDOM.getDocumentElement();
        return GeneratorFactory.createGenerator(generatorElement, resourceManager);
    }

    static {
        AggregatedFeatureGeneratorFactory.register(factories);
        CachedFeatureGeneratorFactory.register(factories);
        CharacterNgramFeatureGeneratorFactory.register(factories);
        DefinitionFeatureGeneratorFactory.register(factories);
        DictionaryFeatureGeneratorFactory.register(factories);
        PreviousMapFeatureGeneratorFactory.register(factories);
        SentenceFeatureGeneratorFactory.register(factories);
        TokenClassFeatureGeneratorFactory.register(factories);
        TokenFeatureGeneratorFactory.register(factories);
        BigramNameFeatureGeneratorFactory.register(factories);
        TokenPatternFeatureGeneratorFactory.register(factories);
        WindowFeatureGeneratorFactory.register(factories);
        CustomFeatureGeneratorFactory.register(factories);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CustomFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        CustomFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            Class<?> featureGenClass;
            String featureGeneratorClassName = generatorElement.getAttribute("class");
            try {
                featureGenClass = Class.forName(featureGeneratorClassName);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            AdaptiveFeatureGenerator generator = null;
            try {
                generator = (AdaptiveFeatureGenerator)featureGenClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new InvalidFormatException("Failed to instantiate custom class!", e);
            }
            catch (IllegalAccessException e) {
                throw new InvalidFormatException("Failed to instantiate custom class!", e);
            }
            return generator;
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("custom", new CustomFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WindowFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        WindowFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            int nextLength;
            int prevLength;
            Element nestedGeneratorElement = null;
            NodeList kids = generatorElement.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node childNode = kids.item(i);
                if (!(childNode instanceof Element)) continue;
                nestedGeneratorElement = (Element)childNode;
                break;
            }
            if (nestedGeneratorElement == null) {
                throw new InvalidFormatException("window feature generator must containa agregator element");
            }
            AdaptiveFeatureGenerator nestedGenerator = GeneratorFactory.createGenerator(nestedGeneratorElement, resourceManager);
            String prevLengthString = generatorElement.getAttribute("prevLength");
            try {
                prevLength = Integer.parseInt(prevLengthString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("prevLength attribute is not a number!");
            }
            String nextLengthString = generatorElement.getAttribute("nextLength");
            try {
                nextLength = Integer.parseInt(nextLengthString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("nextLength attribute is not a number!");
            }
            return new WindowFeatureGenerator(nestedGenerator, prevLength, nextLength);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("window", new WindowFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TokenPatternFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenPatternFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new TokenPatternFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("tokenpattern", new TokenPatternFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BigramNameFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        BigramNameFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new BigramNameFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("bigram", new BigramNameFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TokenFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new TokenFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("token", new TokenPatternFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TokenClassFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenClassFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new TokenClassFeatureGenerator(true);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("tokenclass", new TokenClassFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SentenceFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        SentenceFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            String beginFeatureString = generatorElement.getAttribute("begin");
            boolean beginFeature = true;
            if (beginFeatureString.length() != 0) {
                beginFeature = Boolean.parseBoolean(beginFeatureString);
            }
            String endFeatureString = generatorElement.getAttribute("end");
            boolean endFeature = true;
            if (endFeatureString.length() != 0) {
                endFeature = Boolean.parseBoolean(endFeatureString);
            }
            return new SentenceFeatureGenerator(beginFeature, endFeature);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("sentence", new SentenceFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PreviousMapFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        PreviousMapFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new PreviousMapFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("prevmap", new PreviousMapFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DictionaryFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        DictionaryFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String dictResourceKey = generatorElement.getAttribute("dict");
            Object dictResource = resourceManager.getResource(dictResourceKey);
            if (!(dictResource instanceof Dictionary)) {
                throw new InvalidFormatException("No dictionary resource for key: " + dictResourceKey);
            }
            String prefix = generatorElement.getAttribute("prefix");
            return new DictionaryFeatureGenerator(prefix, (Dictionary)dictResource);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("dictionary", new DictionaryFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefinitionFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        private static final String ELEMENT_NAME = "definition";

        private DefinitionFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            return new OutcomePriorFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put(ELEMENT_NAME, new DefinitionFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CharacterNgramFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        CharacterNgramFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            int max;
            int min;
            String minString = generatorElement.getAttribute("min");
            try {
                min = Integer.parseInt(minString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("min attribute is not a number!");
            }
            String maxString = generatorElement.getAttribute("max");
            try {
                max = Integer.parseInt(maxString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("max attribute is not a number!");
            }
            return new CharacterNgramFeatureGenerator(min, max);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("charngram", new CharacterNgramFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        private CachedFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            Element cachedGeneratorElement = null;
            NodeList kids = generatorElement.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node childNode = kids.item(i);
                if (!(childNode instanceof Element)) continue;
                cachedGeneratorElement = (Element)childNode;
                break;
            }
            if (cachedGeneratorElement == null) {
                throw new InvalidFormatException("Could not find containing generator element!");
            }
            AdaptiveFeatureGenerator chachedGenerator = GeneratorFactory.createGenerator(cachedGeneratorElement, resourceManager);
            return new CachedFeatureGenerator(chachedGenerator);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("cache", new CachedFeatureGeneratorFactory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AggregatedFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        AggregatedFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            LinkedList<AdaptiveFeatureGenerator> aggregatedGenerators = new LinkedList<AdaptiveFeatureGenerator>();
            NodeList childNodes = generatorElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element aggregatedGeneratorElement = (Element)childNode;
                aggregatedGenerators.add(GeneratorFactory.createGenerator(aggregatedGeneratorElement, resourceManager));
            }
            return new AggregatedFeatureGenerator(aggregatedGenerators.toArray(new AdaptiveFeatureGenerator[aggregatedGenerators.size()]));
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("generators", new AggregatedFeatureGeneratorFactory());
        }
    }

    static interface XmlFeatureGeneratorFactory {
        public AdaptiveFeatureGenerator create(Element var1, FeatureGeneratorResourceProvider var2) throws InvalidFormatException;
    }
}

