/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.model.TrainUtil;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.postag.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class POSTaggerTrainerTool
implements CmdLineTool {
    @Override
    public String getName() {
        return "POSTaggerTrainer";
    }

    @Override
    public String getShortDescription() {
        return "trains a model for the part-of-speech tagger";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(TrainerToolParams.class);
    }

    static ObjectStream<POSSample> openSampleData(String sampleDataName, File sampleDataFile, Charset encoding) {
        CmdLineUtil.checkInputFile(sampleDataName + " Data", sampleDataFile);
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(sampleDataFile);
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), encoding);
        return new WordTagSampleStream(lineStream);
    }

    @Override
    public void run(String[] args) {
        POSModel model;
        if (!ArgumentParser.validateArguments(args, TrainerToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TrainerToolParams params = ArgumentParser.parse(args, TrainerToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), true);
        if (mlParams != null && !TrainUtil.isValid(mlParams.getSettings())) {
            System.err.println("Training parameters file is invalid!");
            throw new TerminateToolException(-1);
        }
        File trainingDataInFile = params.getData();
        File modelOutFile = params.getModel();
        CmdLineUtil.checkOutputFile("pos tagger model", modelOutFile);
        ObjectStream<POSSample> sampleStream = POSTaggerTrainerTool.openSampleData("Training", trainingDataInFile, params.getEncoding());
        Dictionary ngramDict = null;
        Integer ngramCutoff = params.getNgram();
        if (ngramCutoff != null) {
            System.err.print("Building ngram dictionary ... ");
            try {
                ngramDict = POSTaggerME.buildNGramDictionary(sampleStream, ngramCutoff);
                sampleStream.reset();
            }
            catch (IOException e) {
                CmdLineUtil.printTrainingIoError(e);
                throw new TerminateToolException(-1);
            }
            System.err.println("done");
        }
        try {
            POSDictionary tagdict = null;
            if (params.getDict() != null) {
                tagdict = POSDictionary.create(new FileInputStream(params.getDict()));
            }
            model = mlParams == null ? POSTaggerME.train(params.getLang(), sampleStream, POSTaggerTrainerTool.getModelType(params.getType()), tagdict, ngramDict, params.getCutoff(), params.getIterations()) : POSTaggerME.train(params.getLang(), sampleStream, mlParams, tagdict, ngramDict);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("pos tagger", modelOutFile, model);
    }

    static ModelType getModelType(String modelString) {
        if (modelString == null) {
            modelString = "maxent";
        }
        ModelType model = modelString.equals("maxent") ? ModelType.MAXENT : (modelString.equals("perceptron") ? ModelType.PERCEPTRON : (modelString.equals("perceptron_sequence") ? ModelType.PERCEPTRON_SEQUENCE : null));
        return model;
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

