/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.dictionary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.dictionary.DictionaryBuilderParams;
import opennlp.tools.dictionary.Dictionary;

public class DictionaryBuilderTool
implements CmdLineTool {
    public String getName() {
        return "DictionaryBuilder";
    }

    public String getShortDescription() {
        return "builds a new dictionary";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(Params.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, Params.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        Params params = ArgumentParser.parse(args, Params.class);
        File dictInFile = params.getInputFile();
        File dictOutFile = params.getOutputFile();
        Charset encoding = params.getEncoding();
        CmdLineUtil.checkInputFile("dictionary input file", dictInFile);
        CmdLineUtil.checkOutputFile("dictionary output file", dictOutFile);
        InputStreamReader in = null;
        OutputStream out = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(dictInFile), encoding);
            out = new FileOutputStream(dictOutFile);
            Dictionary dict = Dictionary.parseOneEntryPerLine(in);
            dict.serialize(out);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {}
        }
    }

    static interface Params
    extends DictionaryBuilderParams {
    }
}

