/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerCrossValidator;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import opennlp.tools.cmdline.chunker.ChunkerTrainerTool;
import opennlp.tools.cmdline.chunker.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.FMeasure;

public final class ChunkerCrossValidatorTool
implements CmdLineTool {
    public String getName() {
        return "ChunkerCrossValidator";
    }

    public String getShortDescription() {
        return "K-fold cross validator for the chunker";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(CVToolParams.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, CVToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        CVToolParams params = ArgumentParser.parse(args, CVToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), false);
        File trainingDataInFile = params.getData();
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        ObjectStream<ChunkSample> sampleStream = ChunkerTrainerTool.openSampleData("Training Data", trainingDataInFile, params.getEncoding());
        LinkedList<ChunkerEvaluationMonitor> listeners = new LinkedList<ChunkerEvaluationMonitor>();
        ChunkerDetailedFMeasureListener detailedFMeasureListener = null;
        if (params.getMisclassified().booleanValue()) {
            listeners.add(new ChunkEvaluationErrorListener());
        }
        if (params.getDetailedF().booleanValue()) {
            detailedFMeasureListener = new ChunkerDetailedFMeasureListener();
            listeners.add(detailedFMeasureListener);
        }
        if (mlParams == null) {
            mlParams = new TrainingParameters();
            mlParams.put("Algorithm", "MAXENT");
            mlParams.put("Iterations", Integer.toString(params.getIterations()));
            mlParams.put("Cutoff", Integer.toString(params.getCutoff()));
        }
        ChunkerCrossValidator validator = new ChunkerCrossValidator(params.getLang(), mlParams, listeners.toArray(new ChunkerEvaluationMonitor[listeners.size()]));
        try {
            validator.evaluate(sampleStream, params.getFolds());
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        if (detailedFMeasureListener == null) {
            FMeasure result = validator.getFMeasure();
            System.out.println(result.toString());
        } else {
            System.out.println(detailedFMeasureListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

