/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.semanticdesktop.aperture.util.StringUtil;

public class XmlWriter {
    private static final char[] LINE_SEPARATOR = System.getProperty("line.separator").toCharArray();
    private Writer writer;
    private String charEncoding;
    private boolean prettyPrint = false;
    private int indentLevel = 0;
    private char[] indentString = "\t".toCharArray();
    private ArrayList attNames = new ArrayList();
    private HashMap attValues = new HashMap();

    public XmlWriter(Writer writer) {
        this.writer = writer;
    }

    public XmlWriter(OutputStream outputStream) {
        try {
            this.charEncoding = "UTF-8";
            this.writer = new OutputStreamWriter(outputStream, this.charEncoding);
            this.writer = new BufferedWriter(this.writer);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 character encoding not supported on this platform");
        }
    }

    public XmlWriter(OutputStream outputStream, String charEncoding) throws UnsupportedEncodingException {
        this.charEncoding = charEncoding;
        this.writer = new OutputStreamWriter(outputStream, charEncoding);
        this.writer = new BufferedWriter(this.writer);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean prettyPrintEnabled() {
        return this.prettyPrint;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString.toCharArray();
    }

    public String getIndentString() {
        return new String(this.indentString);
    }

    public void startDocument() throws IOException {
        this.writer.write("<?xml version='1.0'");
        if (this.charEncoding != null) {
            this.writer.write(" encoding='");
            this.writer.write(this.charEncoding);
            this.writer.write(39);
        }
        this.writer.write("?>");
        this.writeLn();
    }

    public void endDocument() throws IOException {
        this.writer.flush();
        this.writer = null;
    }

    public void setAttribute(String name, String value) {
        this.attNames.add(name);
        this.attValues.put(name, value);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void startTag(String elName) throws IOException {
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(elName);
        this.writeAtts();
        this.writer.write(62);
        this.writeLn();
        ++this.indentLevel;
    }

    public void endTag(String elName) throws IOException {
        --this.indentLevel;
        this.writeIndent();
        this.writer.write("</");
        this.writer.write(elName);
        this.writer.write(62);
        this.writeLn();
    }

    public void emptyElement(String elName) throws IOException {
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(elName);
        this.writeAtts();
        this.writer.write("/>");
        this.writeLn();
    }

    public void textElement(String elName, String text) throws IOException {
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(elName);
        this.writeAtts();
        this.writer.write(62);
        this.text(text);
        this.writer.write("</");
        this.writer.write(elName);
        this.writer.write(62);
        this.writeLn();
    }

    public void textElement(String elName, int value) throws IOException {
        this.textElement(elName, String.valueOf(value));
    }

    public void textElement(String elName, long value) throws IOException {
        this.textElement(elName, String.valueOf(value));
    }

    public void textElement(String elName, boolean value) throws IOException {
        this.textElement(elName, String.valueOf(value));
    }

    public void text(String text) throws IOException {
        text = StringUtil.replace("&", "&amp;", text);
        text = StringUtil.replace("<", "&lt;", text);
        text = StringUtil.replace("]]>", "]]&gt;", text);
        this.writer.write(text);
    }

    public void comment(String comment) throws IOException {
        this.writeIndent();
        this.writer.write("<!-- ");
        this.writer.write(comment);
        this.writer.write(" -->");
        this.writeLn();
    }

    public void emptyLine() throws IOException {
        this.writeLn();
    }

    private void writeAtts() throws IOException {
        int nrAttNames = this.attNames.size();
        for (int i = 0; i < nrAttNames; ++i) {
            String name = (String)this.attNames.get(i);
            String value = (String)this.attValues.get(name);
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("='");
            if (value != null) {
                value = StringUtil.replace("&", "&amp;", value);
                value = StringUtil.replace("<", "&lt;", value);
                value = StringUtil.replace("'", "&apos;", value);
                this.writer.write(value);
            }
            this.writer.write(39);
        }
        this.attNames.clear();
        this.attValues.clear();
    }

    private final void writeLn() throws IOException {
        if (this.prettyPrint) {
            this.writer.write(LINE_SEPARATOR);
        }
    }

    private final void writeIndent() throws IOException {
        if (this.prettyPrint) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.write(this.indentString);
            }
        }
    }
}

